% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-preprocessing.R
\name{ProminentPoints}
\alias{ProminentPoints}
\title{Preprocessing: Prominent Points}
\description{
This is a class or removing points that are close or far from
the diagonal in persistence diagrams. If persistence diagrams are 2-column
\link[tibble:tibble]{tibble::tibble}s (i.e. persistence diagrams with ordinary features),
points are ordered and thresholded by distance-to-diagonal. If persistence
diagrams are 1-column \link[tibble:tibble]{tibble::tibble}s (i.e. persistence diagrams with
essential features), points are not ordered and thresholded by first
coordinate.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
pp <- ProminentPoints$new()
pp$apply(dgm)
pp$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:PreprocessingStep]{rgudhi::PreprocessingStep}} -> \code{ProminentPoints}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ProminentPoints-new}{\code{ProminentPoints$new()}}
\item \href{#method-ProminentPoints-clone}{\code{ProminentPoints$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="apply"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-apply'><code>rgudhi::PreprocessingStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit'><code>rgudhi::PreprocessingStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="fit_transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-fit_transform'><code>rgudhi::PreprocessingStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PreprocessingStep" data-id="transform"><a href='../../rgudhi/html/PreprocessingStep.html#method-PreprocessingStep-transform'><code>rgudhi::PreprocessingStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProminentPoints-new"></a>}}
\if{latex}{\out{\hypertarget{method-ProminentPoints-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{ProminentPoints}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProminentPoints$new(
  use = FALSE,
  num_pts = 10,
  threshold = -1,
  location = c("upper", "lower")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use}}{A boolean value specifying whether to use the class. Defaults
to \code{FALSE}.}

\item{\code{num_pts}}{An integer value specifying the cardinality threshold.
Defaults to \code{10L}. If \code{location == "upper"}, keeps the top \code{num_pts}
points that are the farthest away from the diagonal. If \code{location == "lower"}, keeps the top \code{num_pts} points that are the closest to the
diagonal.}

\item{\code{threshold}}{A numeric value specifying the distance-to-diagonal
threshold. Defaults to \code{-1.0}. If \code{location == "upper"}, keeps the
points that are at least at a distance threshold from the diagonal. If
\code{location == "lower"}, keeps the points that are at most at a distance
threshold from the diagonal.}

\item{\code{location}}{A string specifying whether to keep the points that are
far away (\code{"upper"}) or close (\code{"lower"}) to the diagonal. Defaults to
\code{"upper"}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{ProminentPoints}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ProminentPoints-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ProminentPoints-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ProminentPoints$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
