\name{rhcoclust_internet}
\alias{rhcoclust_internet}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Interaction network (internet) of the 'rhcoclust' objects
}
\description{
This function is used for visualization of clustering interaction network plot for the objects that are generated by rhcoclust and list of up-regulated and down-regulated variables list. There are three layers in the network plot, (i) genes (rows) are shown in the first layer, (ii) co-cluster are in the second layer and (iii) columns (compounds) are in the last layer. Red and blue color indicates up and down regulated respectively.
}
\usage{
rhcoclust_internet(data, CoClustObj, plot.internet = FALSE,
cex.nodes = 0.7, edge.width = 1)
}
\arguments{
  \item{data}{A data matrix containing data having the characteristics of interval and ratio level of measurement or continuous data}
    \item{CoClustObj}{A list of output objects from rhcoclust}
    \item{plot.internet}{To set no plotting as the default for interaction network (internet) }
    \item{cex.nodes}{
A numerical value giving to control/annotation node size in the network. Default is 0.7.
}
\item{edge.width}{
A numerical value giving to control/annotation edge width in the network. Default is 1.
}
}

\value{
Plot
A \link{list} up-regulated and down-regulated variables.

}

\author{
Md. Bahadur Badsha <mbbadshar@gmail.com>
}

\seealso{
\link{rhcoclust} for generating a graph objects for clustering network
}
\examples{
# Load necessary library
library(rhcoclust)
library(fields)

# Load real data
data("toxygates_data")

# Load predefined simulated data
data("simu_data")

# Data analysis using real data by rhcoclust. Note, for analysis of predefined
# simulated data
data <- simu_data
# Real data use: data <- toxygates_data

# Apply rhcoclust to identify significant co-cluster of samples and their regulatory features
CoClustObj <- rhcoclust(data, rk=4, ck=3, method.dist = "manhattan", method.hclust = "ward.D")

# Plot interaction network (internet)
# Please use dev.off() to avoid the figure margin from previous plot
# mar order: bottom, left, top, and right
# please use par(mar=c(5,2,5,2)) or modify when necessary to best fit for the plot
Netrhcoclust <- rhcoclust_internet(data, CoClustObj = CoClustObj, plot.internet =
TRUE, cex.nodes = 0.7, edge.width = 1)
# Please change or add any parameter if needed.
text(x = -1, y = 1.1, "Row Cluster", cex = 0.7)
# Please change or add any parameter if needed.
text(x = 0, y = 1.1, "Co-Cluster", cex = 0.7)
# Please change or add any parameter if needed.
text(x = 1, y = 1.1, "Column Cluster", cex = 0.7)
}
