% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{three_channel_model}
\alias{three_channel_model}
\title{A three-channel model of quadratic phase coupling}
\usage{
three_channel_model(
  f1,
  f2,
  f3,
  num_samples = 256,
  num_observations = 100,
  input_freq = c(1.2, 0.7, 0.8),
  noise_sd = 1
)
}
\arguments{
\item{f1}{A function of period \eqn{2 \pi}{2 * pi} for the first channel.}

\item{f2}{A function of period \eqn{2 \pi}{2 * pi} for the second channel.}

\item{f3}{A function of period \eqn{2 \pi}{2 * pi} for the third channel.}

\item{num_samples}{The number of sampling points in an observation.}

\item{num_observations}{The number of observations.}

\item{input_freq}{The scaling factor for the frequencies of input periodic functions.
It can be a scalar or a vector of length three.
If a scalar is given, the same frequency is used for all of inputs.}

\item{noise_sd}{The standard deviation of a Gaussian noise perturbing samples.
It can be a scalar or a vector of length three.
If a scalar is given, the same value is used for all of noises.
Giving 0 is possible and specifies no noise.}
}
\value{
A list of six data frames:
\code{i1}, \code{i2}, \code{i3}, \code{o1}, \code{o2}, and \code{o3}.
Each element has \code{num_observations} columns and \code{num_samples} rows.
\code{i1}, \code{i2}, and \code{i3} are observations of input signals;
\code{o1}, \code{o2}, and \code{o3} are of output.
}
\description{
Simulate observations by a three-channel model of quadratic phase coupling.
}
\details{
Given three periodic functions, this function generate a list of three data
frames in which each column represents a simulated observation at a channel.
The phase is chosen at random from \eqn{[0, 2 \pi]}{[0, 2 * pi]} for each
observation and each channel.
}
\examples{
sawtooth <- function(r) {
    x <- r/(2*pi)
    x - floor(x) - 0.5
}
data <- three_channel_model(cos, sin, sawtooth,
                            input_freq = c(0.2, 0.3, 0.4),
                            noise_sd = 0.9)

}
