% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_calcs.R
\name{spectral_distance}
\alias{spectral_distance}
\title{Find the Spectral Distance Between Two Hypergraphs}
\usage{
spectral_distance(hype1, hype2, matrix = "laplacian")
}
\arguments{
\item{hype1}{A hypergraph object}

\item{hype2}{A hypergraph object}

\item{matrix}{The matrix to calculate the spectral distance with respect to.
Out of \code{"laplacian"}, \code{"adjacency"}, \code{"vert_norm_lap_mat"} and
\code{"hype_norm_lap_mat"}}
}
\value{
A number representing the spectral distance between the two hypergraphs
with respect to the given matrix
}
\description{
Find the Spectral Distance Between Two Hypergraphs
}
\examples{
h1 <- example_hype()
h2 <- example_hype()
spectral_distance(h1, h2)
}
