% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_contrast.R
\name{assertDesignContrast}
\alias{assertDesignContrast}
\title{Check dimensionality of both design and contrast matrix}
\usage{
assertDesignContrast(nsample, design, contrast)
}
\arguments{
\item{nsample}{Integer, number of samples}

\item{design}{Design matrix}

\item{contrast}{Contrast matrix}
}
\value{
Side effect is used: the function stops if there are errors in the
dimensionalities
}
\description{
Check dimensionality of both design and contrast matrix
}
\examples{

nsample <- 4
design <- matrix(1:20, ncol=5)
contrast <- matrix(c(-1,1,0,0,0, 0,1,0,-1,0), nrow=5)
assertDesignContrast(nsample, design, contrast)

}
\seealso{
\code{\link{assertDesign}}, \code{\link{assertContrast}}
}
