% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-base.R
\name{cbind_id_tbl}
\alias{cbind_id_tbl}
\alias{rbind_id_tbl}
\alias{merge.id_tbl}
\alias{split.id_tbl}
\alias{rbind_lst}
\alias{merge_lst}
\alias{unmerge}
\title{ICU class data reshaping}
\usage{
cbind_id_tbl(
  ...,
  keep.rownames = FALSE,
  check.names = FALSE,
  key = NULL,
  stringsAsFactors = FALSE
)

rbind_id_tbl(..., use.names = TRUE, fill = FALSE, idcol = NULL)

\method{merge}{id_tbl}(x, y, by = NULL, by.x = NULL, by.y = NULL, ...)

\method{split}{id_tbl}(x, ...)

rbind_lst(x, ...)

merge_lst(x)

unmerge(x, col_groups = as.list(data_vars(x)), by = meta_vars(x), na_rm = TRUE)
}
\arguments{
\item{...}{Objects to combine}

\item{keep.rownames, check.names, key, stringsAsFactors}{Forwarded to
\link[data.table:data.table]{data.table::data.table}}

\item{use.names, fill, idcol}{Forwarded to \link[data.table:rbindlist]{data.table::rbindlist}}

\item{x, y}{Objects to combine}

\item{by, by.x, by.y}{Column names used for combining data}

\item{col_groups}{A list of character vectors defining the grouping of
non-by columns}

\item{na_rm}{Logical flag indicating whether to remove rows that have all
missing entries in the respective \code{col_groups} group}
}
\value{
Either \code{id_tbl} or \code{ts_tbl} objects (depending on inputs) or lists
thereof in case of \code{split()} and \code{unmerge()}.
}
\description{
Utilities for reshaping \code{id_tbl} and \code{ts_tbl} objects.
}
\keyword{internal}
