% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrationevidence.R
\name{integration_evidence}
\alias{integration_evidence}
\title{Evidence of Integration}
\usage{
integration_evidence(series, parts = NULL)
}
\arguments{
\item{series}{Matrix specifying two or more time series.}

\item{parts}{Vector giving a specific partitioning to use.}
}
\value{
A list containing minimum, \code{min}, and maximum, \code{max},
        values of integration for each observation and logicals indicating if
	   the system is \code{integrated} or, if \code{parts} is provided,
	   returns a vector giving the evidence of integration for each
        observations.
}
\description{
Given a sequence of `n` observed states of `l` random variables (\code{series}),
compute the evidence of integration for each partitioning of the `l`
variables, and return the minimum and maximum evidence for each observation.
If the number of variables `l` is large, the user can test a small subset of
the partitioning schemata by providing a partitioning \code{parts} to increase
confidence that the system is integrated. In this case, the function computes
and returns the evidence of integration for each observation with respect to
the partitioning \code{parts}.
}
\examples{
# Evidence of Integration of three time series:
series      <- matrix(0, nrow = 10, ncol = 3)
series[, 1] <- c(0, 1, 0, 1, 1, 1, 0, 0, 1, 0)
series[, 2] <- c(0, 1, 0, 1, 1, 1, 0, 0, 1, 0)
series[, 3] <- c(1, 1, 1, 1, 1, 0, 0, 0, 0, 0)
# min        = c(-0.322 0.263 -0.322 0.263 0.263 -0.322 0.263 0.263 -0.322 0.263)
# max        = c( 1.000 1.263  1.000 1.263 1.263  1.000 1.263 1.263  1.000 1.263)
# integrated = c( FALSE  TRUE  FALSE  TRUE  TRUE  FALSE  TRUE  TRUE  FALSE  TRUE)
integration_evidence(series)

# Evidence of Integration of three time series for the partitionning c(1, 1, 2)
parts <- c(1, 1, 2)
# -0.322 0.263 -0.322 0.263 0.263 -0.322 0.263 0.263 -0.322 0.263
integration_evidence(series, parts)
}
