% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.R
\name{age.F14C}
\alias{age.F14C}
\title{Calculate F14C values from C14 ages}
\usage{
age.F14C(mn, sdev = c(), decimals = 3)
}
\arguments{
\item{mn}{Reported mean of the 14C age.}

\item{sdev}{Reported error of the 14C age. If left empty, will translate mn to F14C.}

\item{decimals}{Amount of decimals required for the F14C value.}
}
\value{
F14C values from C14 ages.
}
\description{
Calculate F14C values from radiocarbon ages
}
\details{
Post-bomb dates are often reported as F14C or fraction modern carbon. Since Bacon expects radiocarbon ages,
this function can be used to calculate F14C values from radiocarbon ages. The reverse function of \link{F14C.age}.
}
\examples{
  age.F14C(-2000, 20)
}
