% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_pkg_r_package.R
\name{assess_pkg_r_package}
\alias{assess_pkg_r_package}
\title{Assess an R Package riskmetric with package name and version}
\usage{
assess_pkg_r_package(package_name, version = NA, repos = NULL)
}
\arguments{
\item{package_name}{A character string specifying the name of the package to assess.}

\item{version}{A character string specifying the version of the package to assess. Default is `NA`, which assesses the latest version.}

\item{repos}{A character string specifying the repo directly. Default is NULL, which uses the mirrors}
}
\value{
The function returns a list of assessment results generated by the `risk.assessr::assess_pkg` function. 
If the package cannot be downloaded or installed, an error message is returned.
}
\description{
This function use `risk.assessr::assess_pkg` assessment function with only the package name and version
}
\details{
This function follows these steps:
\enumerate{
  \item Downloads the specified R package
  \item Installs the downloaded package in a temporary location.
  \item Runs the `risk.assessr::assess_pkg` function to assess the package for risks and issues.
  \item Returns the results of the assessment.
}
}
\examples{
\donttest{
r <- getOption("repos")
# save current repo options  
old <- options(repos = r)
r["CRAN"] = "http://cran.us.r-project.org"
options(repos = r)#' 

results <- assess_pkg_r_package("here", version = "1.0.1")

# restore user's repo options
options(old)

print(results)
}

}
