% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_prob_prob.R
\name{comp_err}
\alias{comp_err}
\title{Compute overall error rate (err) from probabilities.}
\usage{
comp_err(prev, sens, spec)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}
}
\value{
Overall error rate \code{\link{err}} as a probability (proportion).
A warning is provided for NaN values.
}
\description{
\code{comp_err} computes overall error rate \code{\link{err}}
from 3 essential probabilities
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}.
}
\details{
\code{comp_err} uses \code{\link{comp_acc}} to
compute \code{\link{err}} as the
complement of \code{\link{acc}}:

\code{err = 1 - acc}

See \code{\link{comp_acc}} and \code{\link{acc}}
for further details and
\code{\link{accu}} for other accuracy metrics
and several possible interpretations of accuracy.
}
\examples{
# ways to work:
comp_err(.10, .200, .300)  # => err = 0.71
comp_err(.50, .333, .666)  # => err = 0.5005

# watch out for vectors:
prev.range <- seq(0, 1, by = .1)
comp_err(prev.range, .5, .5)  # => 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5

# watch out for extreme values:
comp_err(1, 1, 1)  #  => 0
comp_err(1, 1, 0)  #  => 0

comp_err(1, 0, 1)  #  => 1
comp_err(1, 0, 0)  #  => 1

comp_err(0, 1, 1)  #  => 0
comp_err(0, 1, 0)  #  => 1

comp_err(0, 0, 1)  #  => 0
comp_err(0, 0, 0)  #  => 1


}
\seealso{
\code{\link{comp_acc}} computes overall accuracy \code{\link{acc}} from probabilities;
\code{\link{accu}} lists all accuracy metrics;
\code{\link{comp_accu_prob}} computes exact accuracy metrics from probabilities;
\code{\link{comp_accu_freq}} computes accuracy metrics from frequencies;
\code{\link{comp_sens}} and \code{\link{comp_PPV}} compute related probabilities;
\code{\link{is_extreme_prob_set}} verifies extreme cases;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{is_complement}} verifies probability complements;
\code{\link{comp_prob}} computes current probability information;
\code{\link{prob}} contains current probability information;
\code{\link{is_prob}} verifies probabilities.

Other functions computing probabilities: \code{\link{comp_FDR}},
  \code{\link{comp_FOR}}, \code{\link{comp_NPV}},
  \code{\link{comp_PPV}}, \code{\link{comp_accu_freq}},
  \code{\link{comp_accu_prob}}, \code{\link{comp_acc}},
  \code{\link{comp_comp_pair}},
  \code{\link{comp_complement}},
  \code{\link{comp_complete_prob_set}},
  \code{\link{comp_fart}}, \code{\link{comp_mirt}},
  \code{\link{comp_ppod}}, \code{\link{comp_prob_freq}},
  \code{\link{comp_prob}}, \code{\link{comp_sens}},
  \code{\link{comp_spec}}

Other metrics: \code{\link{accu}}, \code{\link{acc}},
  \code{\link{comp_accu_freq}},
  \code{\link{comp_accu_prob}}, \code{\link{comp_acc}},
  \code{\link{err}}
}
\concept{functions computing probabilities}
\concept{metrics}
