% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg.R
\name{missing_arg}
\alias{missing_arg}
\alias{is_missing}
\alias{maybe_missing}
\title{Generate or handle a missing argument}
\usage{
missing_arg()

is_missing(x)

maybe_missing(x)
}
\arguments{
\item{x}{An object that might be the missing argument.}
}
\description{
These functions help using the missing argument as a regular R
object. It is valid to generate a missing argument and assign it in
the current environment or in a list. However, once assigned in the
environment, the missing argument normally cannot be touched.
\code{maybe_missing()} checks whether the object is the missing
argument, and regenerate it if needed to prevent R from throwing a
missing error. In addition, \code{is_missing()} lets you check for a
missing argument in a larger range of situations than
\code{\link[base:missing]{base::missing()}} (see examples).
}
\examples{
# The missing argument can be useful to generate calls
quo(f(x = !! missing_arg()))
quo(f(x = !! NULL))


# It is perfectly valid to generate and assign the missing
# argument.
x <- missing_arg()
l <- list(missing_arg())

# Note that accessing a missing argument contained in a list does
# not trigger an error:
l[[1]]
is.null(l[[1]])

# But if the missing argument is assigned in the current
# environment, it is no longer possible to touch it. The following
# lines would all return errors:
#> x
#> is.null(x)

# In these cases, you can use maybe_missing() to manipulate an
# object that might be the missing argument without triggering a
# missing error:
maybe_missing(x)
is.null(maybe_missing(x))
is_missing(maybe_missing(x))


# base::missing() does not work well if you supply an
# expression. The following lines would throw an error:

#> missing(missing_arg())
#> missing(l[[1]])

# while is_missing() will work as expected:
is_missing(missing_arg())
is_missing(l[[1]])
}
