% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd-handlers.R
\name{restarting}
\alias{restarting}
\title{Create a restarting handler}
\usage{
restarting(.restart, ..., .fields = NULL)
}
\arguments{
\item{.restart}{The name of a restart.}

\item{...}{Additional arguments passed on the restart
function. These arguments are evaluated only once and
immediately, when creating the restarting handler. Furthermore,
they support \link[=tidy-dots]{tidy dots} features.}

\item{.fields}{A character vector specifying the fields of the
condition that should be passed as arguments to the restart. If
named, the names (except empty names \code{""}) are used as
argument names for calling the restart function. Otherwise the
the fields themselves are used as argument names.}
}
\description{
This constructor automates the common task of creating an
\code{\link[=inplace]{inplace()}} handler that invokes a restart.
}
\details{
Jumping to a restart point from an inplace handler has two
effects. First, the control flow jumps to wherever the restart was
established, and the restart function is called (with \code{...}, or
\code{.fields} as arguments). Execution resumes from the
\code{\link[=with_restarts]{with_restarts()}} call. Secondly, the transfer of the control flow
out of the function that signalled the condition means that the
handler has dealt with the condition. Thus the condition will not
be passed on to other potential handlers established on the stack.
}
\examples{
# This is a restart that takes a data frame and names as arguments
rst_bar <- function(df, nms) {
  stats::setNames(df, nms)
}

# This restart is simpler and does not take arguments
rst_baz <- function() "baz"

# Signalling a condition parameterised with a data frame
fn <- function() {
  with_restarts(cnd_signal("foo", foo_field = mtcars),
    rst_bar = rst_bar,
    rst_baz = rst_baz
  )
}

# Creating a restarting handler that passes arguments `nms` and
# `df`, the latter taken from a data field of the condition object
restart_bar <- restarting("rst_bar",
  nms = LETTERS[1:11], .fields = c(df = "foo_field")
)

# The restarting handlers jumps to `rst_bar` when `foo` is signalled:
with_handlers(fn(), foo = restart_bar)

# The restarting() constructor is especially nice to use with
# restarts that do not need arguments:
with_handlers(fn(), foo = restarting("rst_baz"))
}
\seealso{
\code{\link[=inplace]{inplace()}} and \code{\link[=exiting]{exiting()}}.
}
