% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env-binding.R
\name{env_unbind}
\alias{env_unbind}
\title{Remove bindings from an environment}
\usage{
env_unbind(env = caller_env(), nms, inherit = FALSE)
}
\arguments{
\item{env}{An environment.}

\item{nms}{A character vector containing the names of the bindings
to remove.}

\item{inherit}{Whether to look for bindings in the parent
environments.}
}
\value{
The input object \code{env} with its associated environment
modified in place, invisibly.
}
\description{
\code{env_unbind()} is the complement of \code{\link[=env_bind]{env_bind()}}. Like \code{env_has()},
it ignores the parent environments of \code{env} by default. Set
\code{inherit} to \code{TRUE} to track down bindings in parent environments.
}
\examples{
env <- env(foo = 1, bar = 2)
env_has(env, c("foo", "bar"))

# Remove bindings with `env_unbind()`
env_unbind(env, c("foo", "bar"))
env_has(env, c("foo", "bar"))

# With inherit = TRUE, it removes bindings in parent environments
# as well:
parent <- env(empty_env(), foo = 1, bar = 2)
env <- env(parent, foo = "b")

env_unbind(env, "foo", inherit = TRUE)
env_has(env, c("foo", "bar"))
env_has(env, c("foo", "bar"), inherit = TRUE)
}
