% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{lc_colourSlider}
\alias{lc_colourSlider}
\title{Add a colour slider}
\usage{
lc_colourSlider(data = list(), place = NULL, ..., chartId = NULL, with = NULL)
}
\arguments{
\item{data}{Name value pairs of properties, passed through the \code{\link{dat}} function. These
properties will be reevaluated on each \code{\link{updateCharts}} call.}

\item{place}{ID of a container, where to place new chart. Will be ignored if the chart already
exists. If not defined, the chart will be appended to the body of the web pages.}

\item{...}{Name-value pairs of properties that will be evaluated only once and then will remain
constant. These properties can still be changed later using the \code{\link{setProperties}} function.}

\item{chartId}{ID for the chart. All charts must have unique IDs. If a chart with the same ID already
exists, it will be replaced. If ID is not defined, it will be the same as
value of the \code{place} argument. And if both are not defined, the ID will be set to \code{ChartN},
where \code{N - 1} is the number of existing charts.}

\item{with}{A data set from which other properties should be taken. If the data set doesn't have a
column with the requested name, the variable will be searched for outside of the data set. Must be
a data.frame or a list.}
}
\description{
Colour slider provides an easy way to change any continuous colour scale
interactively. If your chart uses a continuous colour scale, you can just
link a colour slider and it will be automatically synchronized with your
chart's colour scale.
}
\section{Available properties}{

You can read more about different properties
\href{https://anders-biostat.github.io/linked-charts/rlc/tutorials/props.html}{here}.

\itemize{
\item \code{chart} - ID of the chart to which the colour slider should be linked.
\item \code{layer} - id of the layer to which the colour slider should be linked.
If the chart has only one layer, this property is optional.}

Global chart settings
\itemize{
\item \code{width} - width of the chart in pixels.
\item \code{heigth} - height of the chart in pixels.
\item \code{paddings} - padding sizes in pixels. Must be a list with all the following fields:
\code{"top", "bottom", "left", "right"}.
\item \code{title} - title of the chart.
\item \code{titleX, titleY} - coordinates of the chart title.
\item \code{titleSize} - font-size of the chart title.}
}

\examples{
\donttest{data("iris")
lc_scatter(dat(x = Sepal.Length, 
               y = Petal.Length,
               colourValue = Petal.Width,
               symbolValue = Species),
           with = iris,
           title = "Iris dataset",
           axisTitleY = "Petal Length",
           axisTitleX = "Sepal Length",
           colourLegendTitle = "Petal Width",
           symbolLegendTitle = "Species",
           showLegend = FALSE,
           chartId = "scatter")

lc_colourSlider(chart = "scatter")}

}
