

test_that("Preflow works", {
  s <- c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5)
  t <- c(2, 3, 3, 4, 2, 5, 3, 6, 4, 6)
  cap <- c(16, 13, 10, 124, 14, 9, 20, 7, 4, 0)
  out <- PreflowRunner(s, t, cap, 1, 6, 6)
  expect_is(out[[3]], "integer")
  expect_is(out[[2]], "integer")
  expect_is(out[[1]], "integer")
  expect_equal(out[[1]], c(7, 0, 0, 21, 14, 4, 18, 7, 4, 0))
  expect_equal(out[[2]], c(1, 1, 1, 1, 1, 0))
  expect_equal(out[[3]], 7)
  out <- MaxFlow(s, t, cap, 1, 6, 6, "Preflow")
  expect_is(out[[3]], "integer")
  expect_is(out[[2]], "integer")
  expect_is(out[[1]], "integer")
  expect_equal(out[[1]], c(7, 0, 0, 21, 14, 4, 18, 7, 4, 0))
  expect_equal(out[[2]], c(1, 1, 1, 1, 1, 0))
  expect_equal(out[[3]], 7)
  expect_error(MaxFlow(s, t, cap, 1, 6, 6, "abc"), "Invalid")
})

test_that("Edmonds-Karp works", {
  s <- c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5)
  t <- c(2, 3, 3, 4, 2, 5, 3, 6, 4, 6)
  cap <- c(16, 13, 10, 124, 14, 9, 20, 7, 4, 0)
  out <- EdmondsKarpRunner(s, t, cap, 1, 6, 6)
  expect_is(out[[3]], "integer")
  expect_is(out[[2]], "integer")
  expect_is(out[[1]], "integer")
  expect_equal(out[[1]], c(7, 0, 0, 7, 0, 0, 0, 7, 0, 0))
  expect_equal(out[[2]], c(1, 1, 1, 1, 1, 0))
  expect_equal(out[[3]], 7)
  out <- MaxFlow(s, t, cap, 1, 6, 6, "EdmondsKarp")
  expect_is(out[[3]], "integer")
  expect_is(out[[2]], "integer")
  expect_is(out[[1]], "integer")
  expect_equal(out[[1]], c(7, 0, 0, 7, 0, 0, 0, 7, 0, 0))
  expect_equal(out[[2]], c(1, 1, 1, 1, 1, 0))
  expect_equal(out[[3]], 7)
  expect_error(MaxFlow(s, t, cap, 1, 6, 6, "abc"), "Invalid")
})

test_that("Circulation works", {
  s <- c(1, 1, 2, 2, 3, 3, 4, 4, 5, 5)
  t <- c(2, 3, 3, 4, 2, 5, 3, 6, 4, 6)
  lower <- c(0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
  upper <- c(16, 13, 10, 124, 14, 9, 20, 7, 4, 0)
  supplies <- c(1, 2, 3, 4, 5, 6)
  out <- NetworkCirculation(s, t, lower, upper, supplies, 6, "Circulation")
  expect_is(out[[1]], "integer")
  expect_is(out[[2]], "integer")
  expect_equal(out[[1]], c(0, 1, 0, 2, 0, 0, 0, 6, 4, 0))
  expect_equal(out[[2]], c(5))
  expect_error(
    NetworkCirculation(s, t, lower, upper, supplies, 6, "abc"),
    "Invalid"
  )
})
