% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{leaveOneOutFun.Kriging}
\alias{leaveOneOutFun.Kriging}
\alias{leaveOneOutFun,Kriging,Kriging-method}
\title{Compute Leave-One-Out (LOO) error for an object with S3 class
\code{"Kriging"} representing a kriging model.}
\usage{
\method{leaveOneOutFun}{Kriging}(object, theta, return_grad = FALSE, bench = FALSE, ...)
}
\arguments{
\item{object}{A \code{Kriging} object.}

\item{theta}{A numeric vector of range parameters at which the LOO
will be evaluated.}

\item{return_grad}{Logical. Should the gradient (w.r.t. \code{theta}) be
returned?}

\item{bench}{Logical. Should the function display benchmarking output}

\item{...}{Not used.}
}
\value{
The leave-One-Out value computed for the given vector
    \eqn{\boldsymbol{\theta}}{\theta} of correlation ranges.
}
\description{
The returned value is the sum of squares \eqn{\sum_{i=1}^n [y_i -
\hat{y}_{i,(-i)}]^2} where \eqn{\hat{y}_{i,(-i)}} is the
prediction of \eqn{y_i}{y[i]} based on the the observations \eqn{y_j}{y[j]}
with \eqn{j \neq i}{j != i}.
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective = "LOO", optim="BFGS")
print(k)

loo <-  function(theta) leaveOneOutFun(k, theta)$leaveOneOut
t <-  seq(from = 0.001, to = 2, length.out = 101)
plot(t, loo(t), type = "l")
abline(v = k$theta(), col = "blue")
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
