% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NuggetKrigingClass.R
\name{update.NuggetKriging}
\alias{update.NuggetKriging}
\title{Update a \code{NuggetKriging} model object with new points}
\usage{
\method{update}{NuggetKriging}(object, y_u, X_u, refit = TRUE, ...)
}
\arguments{
\item{object}{S3 NuggetKriging object.}

\item{y_u}{Numeric vector of new responses (output).}

\item{X_u}{Numeric matrix of new input points.}

\item{refit}{Logical. If \code{TRUE} the model is refitted (default is FALSE).}

\item{...}{Ignored.}
}
\value{
No return value. NuggetKriging object argument is modified.
}
\description{
Update a \code{NuggetKriging} model object with new points
}
\section{Caution}{
 The method \emph{does not return the updated
    object}, but instead changes the content of
    \code{object}. This behaviour is quite unusual in R and
    differs from the behaviour of the methods
    \code{\link[DiceKriging]{update.km}} in \pkg{DiceKriging} and
    \code{\link{update,KM-method}}.
}

\examples{
f <- function(x) 1- 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x)*x^5 + 0.7)
plot(f)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X) + 0.1 * rnorm(nrow(X))
points(X, y, col = "blue")

k <- NuggetKriging(y, X, "matern3_2")

## include design points to see interpolation
x <- sort(c(X,seq(from = 0, to = 1, length.out = 101)))
p <- predict(k, x)
lines(x, p$mean, col = "blue")
polygon(c(x, rev(x)), c(p$mean - 2 * p$stdev, rev(p$mean + 2 * p$stdev)),
 border = NA, col = rgb(0, 0, 1, 0.2))

X_u <- as.matrix(runif(3))
y_u <- f(X_u) + 0.1 * rnorm(nrow(X_u))
points(X_u, y_u, col = "red")

## change the content of the object 'k'
update(k, y_u, X_u)

## include design points to see interpolation
x <- sort(c(X,X_u,seq(from = 0, to = 1, length.out = 101)))
p2 <- predict(k, x)
lines(x, p2$mean, col = "red")
polygon(c(x, rev(x)), c(p2$mean - 2 * p2$stdev, rev(p2$mean + 2 * p2$stdev)),
 border = NA, col = rgb(1, 0, 0, 0.2))
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
