% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{importPBMC}
\alias{importPBMC}
\alias{importBMMC}
\alias{importCGE}
\title{Import prepared dataset publically available}
\usage{
importPBMC(
  dir = getwd(),
  overwrite = FALSE,
  method = "libcurl",
  verbose = getOption("ligerVerbose", TRUE),
  ...
)

importBMMC(
  dir = getwd(),
  overwrite = FALSE,
  method = "libcurl",
  verbose = getOption("ligerVerbose", TRUE),
  ...
)

importCGE(
  dir = getwd(),
  overwrite = FALSE,
  method = "libcurl",
  verbose = getOption("ligerVerbose", TRUE),
  ...
)
}
\arguments{
\item{dir}{Path to download datasets. Default current working directory
\code{getwd()}.}

\item{overwrite}{Logical, if a file exists at corresponding download
location, whether to re-download or directly use this file. Default
\code{FALSE}.}

\item{method}{\code{method} argument directly passed to
\code{\link[utils]{download.file}}. Using \code{"libcurl"} while other
options might not work depending on platform.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{...}{Additional arguments passed to \code{\link{download.file}}}
}
\value{
Constructed \linkS4class{liger} object with QC performed and missing
data removed.
}
\description{
These are functions to download example datasets that are subset from public
data.
\itemize{
\item{\bold{PBMC} - Downsampled from GSE96583, Kang et al, Nature
Biotechnology, 2018. Contains two scRNAseq datasets.}
\item{\bold{BMMC} - Downsampled from GSE139369, Granja et al, Nature
Biotechnology, 2019. Contains two scRNAseq datasets and one scATAC data.}
\item{\bold{CGE} - Downsampled from GSE97179, Luo et al, Science, 2017.
Contains one scRNAseq dataset and one DNA methylation data.}
}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
pbmc <- importPBMC()
bmmc <- importBMMC()
cge <- importCGE()
}
\dontshow{\}) # examplesIf}
}
