% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeObject.R
\name{mergeH5}
\alias{mergeH5}
\title{Merge hdf5 files}
\usage{
mergeH5(
  file.list,
  library.names,
  new.filename,
  format.type = "10X",
  data.name = NULL,
  indices.name = NULL,
  indptr.name = NULL,
  genes.name = NULL,
  barcodes.name = NULL
)
}
\arguments{
\item{file.list}{List of path to hdf5 files.}

\item{library.names}{Vector of library names (corresponding to file.list)}

\item{new.filename}{String of new hdf5 file name after merging (default
new.h5).}

\item{format.type}{string of HDF5 format (10X CellRanger by default).}

\item{data.name}{Path to the data values stored in HDF5 file.}

\item{indices.name}{Path to the indices of data points stored in HDF5 file.}

\item{indptr.name}{Path to the pointers stored in HDF5 file.}

\item{genes.name}{Path to the gene names stored in HDF5 file.}

\item{barcodes.name}{Path to the barcodes stored in HDF5 file.}
}
\value{
Directly generates newly merged hdf5 file.
}
\description{
This function merges hdf5 files generated from different
libraries (cell ranger by default) before they are preprocessed through Liger
pipeline.
}
\examples{
\dontrun{
# For instance, we want to merge two datasets saved in HDF5 files (10X
# CellRanger) paths to datasets: "library1.h5","library2.h5"
# dataset names: "lib1", "lib2"
# name for output HDF5 file: "merged.h5"
mergeH5(list("library1.h5","library2.h5"), c("lib1","lib2"), "merged.h5")
}
}
