% Generated by roxygen2 (4.0.1): do not edit by hand
\name{list.order}
\alias{list.order}
\title{Return the order of each member in a list by expression}
\usage{
list.order(.data, ..., keep.names = FALSE)
}
\arguments{
\item{.data}{\code{list}}

\item{...}{Expressions to evaluate for ordering}

\item{keep.names}{Whether to keep the names of \code{x} in the result}
}
\description{
Return the order of each member in a list by expression
}
\examples{
\dontrun{
x <- list(p1 = list(type="A",score=list(c1=10,c2=8)),
       p2 = list(type="B",score=list(c1=9,c2=9)),
       p3 = list(type="B",score=list(c1=9,c2=7)))
list.order(x,type,desc(score$c2))
list.order(x,min(score$c1,score$c2))
list.order(x,min(score$c1,score$c2),keep.names=TRUE)
}
}

