% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{TimeMin}
\alias{TimeMin}
\title{Identify Time Points Mapping to 0 and 1}
\usage{
TimeMin(v, Subject, Time, ncores)
}
\arguments{
\item{v}{output of \code{\link[limma]{voom}} function.}

\item{Subject}{a vector of subjects or experimental units.}

\item{Time}{a vector of time points.}

\item{ncores}{number of cores for embarrassingly parallel procedure. Default
value of \code{ncores} is 1.}
}
\value{
a vector of 2 components correspinding to the two time points
that are mapping to 0, 1, respectively.
}
\description{
This function is to identify which time points
mapped to 0 and 1 based on the estimated correlations
of observations between all pairs of time points.
The correlation parameters are estimateed by fitting
\code{\link{voomgls_Symm}} to the \code{\link[limma]{voom}} transformed data.
}
\examples{
\donttest{
data(res)
data(covset)
v <- res$ori.res$v
v$E <- v$E[1:2,]
v$weights <- v$weights[1:2,]
Subject <- covset$ear
Time <- covset$time
ncores <- 1
TimeMinout <- rmRNAseq:::TimeMin(v, Subject, Time, ncores)
TimeMinout
}
}
