% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TC_CAR1.R
\name{voomgls_Symm}
\alias{voomgls_Symm}
\title{General Linear Model Using Voom Output corSymm correlction structure}
\usage{
voomgls_Symm(v, Subject, Time, ncores = 1, C.matrix = NULL,
  beta0 = NULL, print.progress = FALSE)
}
\arguments{
\item{v}{output of \code{\link[limma]{voom}} function.}

\item{Subject}{a vector of subjects or experimental units.}

\item{Time}{a vector of time points.}

\item{ncores}{number of cores for embarrassingly parallel procedure. Default
value of \code{ncores} is 1.}

\item{C.matrix}{is a list of matrix Ci in testing H0:  Ci*beta = 0.}

\item{beta0}{vector of the hypothesized value of beta, usually, beta0 is a 0
vector. The default option \code{beta0 = NULL} means that \code{beta0} is a
vector of 0.}

\item{print.progress}{logical indicator, T or F, to print the progress.}
}
\value{
a data frame has G rows (= number of genes) containing all outputs from
  \code{\link{glsSymm}} function, shrinkage estimates of error variances, and
  F-type test statistics calculated by  \code{\link{teststat}} function.
}
\description{
This function run general linear model with \code{\link[nlme]{corSymm}}
correlation structure in function \code{\link[nlme]{gls}} for all genes where
the input data come from the output of \code{\link[limma]{voom}}.
}
\examples{
data(res)
data(covset)
v <- res$ori.res$v
v$E <- v$E[1:20,]
v$weights <- v$weights[1:20,]
Subject <- covset$ear
Time <- covset$time
ncores <- 1
C.matrix <- list()
C.matrix[[1]] <- limma::makeContrasts(line2, levels = design)
C.matrix[[2]] <- limma::makeContrasts(time2, time6, time24, levels = design)
names(C.matrix) <- c("line2", "time")
beta0 <- NULL
print.progress <- FALSE
voomglsout <- rmRNAseq:::voomgls_Symm(v, Subject, Time, ncores, C.matrix, beta0, print.progress)
}
