/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.rnd;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.classifier.attributeIndicators.AttributeIndicators;
import dmLab.classifier.attributeIndicators.J48NodeIndicators;
import dmLab.classifier.rnd.RNDParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.ExperimentIndicators;
import dmLab.utils.cmatrix.AccuracyMeasure;
import dmLab.utils.cmatrix.ConfusionMatrix;
import java.io.IOException;
import java.util.Random;

public final class RNDClassifier
extends Classifier {
    private RNDParams cfg;
    private Random rand;
    private FArray trainArray;

    public RNDClassifier() {
        this.label = labels[RND];
        this.params = new RNDParams();
        this.cfg = (RNDParams)this.params;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean train(FArray trainArray) {
        void var1_2;
        void var2_3;
        this.trainArray = trainArray;
        float start = System.currentTimeMillis();
        if (this.params.verbose) {
            System.out.println("Training...");
        }
        this.rand = new Random((long)this.cfg.seed);
        if (this.params.verbose) {
            System.out.println("Training is done!");
        }
        float stop = System.currentTimeMillis();
        this.learningTime = (float)((double)(var2_3 - var1_2) / 1000.0);
        if (this.params.verbose) {
            System.out.println("Training time: " + DiscFunctions.format(this.learningTime, 2) + " s.");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean test(FArray testArray) {
        void var2_3;
        void var1_2;
        int interval;
        if (this.params.verbose) {
            System.out.print("Testing...");
        }
        float start = System.currentTimeMillis();
        this.confusionMatrix = new ConfusionMatrix(testArray.getColNames(true)[testArray.getDecAttrIdx()], testArray.getDecValues(), testArray.getDecValuesStr());
        int testEventsNumber = testArray.rowsNumber();
        int threshold = interval = (int)Math.ceil(0.1 * (double)testEventsNumber);
        this.predictions = new Prediction[testEventsNumber];
        int decAttrIndex = testArray.getDecAttrIdx();
        int i = 0;
        while (i < testEventsNumber) {
            void var3_9;
            int n = i;
            Object object = testArray;
            RNDClassifier rNDClassifier = this;
            int n2 = -1;
            double d = 0.0;
            object = ((FArray)object).getDecValues();
            int n3 = 0;
            while (n3 < ((Object)object).length) {
                RNDClassifier rNDClassifier2 = rNDClassifier;
                double d2 = rNDClassifier2.rand.nextDouble();
                if (rNDClassifier.params.verbose) {
                    System.out.print("\t" + (float)object[n3] + " " + DiscFunctions.format(d2, 6));
                }
                if (d2 > d) {
                    n2 = n3;
                    d = d2;
                }
                ++n3;
            }
            float predictedDecision = d > 0.0 ? (float)object[n2] : -1.0f;
            float realDecision = testArray.readValue(decAttrIndex, i);
            this.confusionMatrix.add(realDecision, predictedDecision);
            String predictedClassName = testArray.dictionary.toString(predictedDecision);
            this.predictions[i] = new Prediction((String)var3_9, null);
            if (i > threshold && threshold != 0) {
                if (this.params.verbose) {
                    System.out.print((int)(100.0 * (double)i / (double)testEventsNumber) + "% ");
                }
                threshold += interval;
            }
            ++i;
        }
        System.out.print("100% ");
        float stop = System.currentTimeMillis();
        this.testingTime = (float)((double)(var1_2 - var2_3) / 1000.0);
        if (this.params.verbose) {
            System.out.println(" Done!");
        }
        if (this.params.verbose) {
            System.out.println("Testing time: " + DiscFunctions.format(this.testingTime, 2) + " s.");
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addImportances(AttributesRI[] importances) {
        void var3_6;
        void var2_4;
        void var1_1;
        int idx22 = -1;
        int decisionAttrIndex = this.trainArray.getDecAttrIdx();
        while (idx22 == decisionAttrIndex) {
            FArray idx22 = this.trainArray;
            idx22 = this.rand.nextInt(idx22.attributes.length);
        }
        String name = this.trainArray.attributes[idx22].name;
        ExperimentIndicators experimentIndicators = new ExperimentIndicators();
        new ExperimentIndicators().eventsNumber = this.trainSetSize;
        experimentIndicators.predictionQuality = AccuracyMeasure.calcWAcc(this.confusionMatrix.getMatrix());
        var1_1[0].addImportances((String)var2_4, (ExperimentIndicators)var3_6, (AttributeIndicators)new J48NodeIndicators(0));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean saveDefinition(String path, String name) throws IOException {
        void var2_2;
        void var1_1;
        if (this.params.verbose) {
            System.out.print("Saving classifier definition...");
        }
        this.params.save((String)var1_1, (String)var2_2);
        if (this.params.verbose) {
            System.out.println(" Done!");
        }
        return true;
    }

    @Override
    public final boolean init() {
        return true;
    }

    @Override
    public final boolean finish() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(" ### RND Classifier ### \n");
        tmp.append("label=" + this.label).append('\n');
        return var1_1.toString();
    }
}

