/*
 * Decompiled with CFR 0.152.
 */
package weka;

import java.io.File;
import java.io.IOException;
import weka.classifiers.trees.J48;
import weka.core.Instances;
import weka.core.converters.ArffLoader;

public class C45 {
    private ArffLoader arffLoader;
    protected J48 j48Tree = new J48();

    public C45() {
        this.setDefaultParameters();
        this.arffLoader = new ArffLoader();
    }

    public static void main(String[] args) {
        C45 c45 = new C45();
        File f = new File("./data/weather.arff");
        System.out.println(f.getAbsolutePath());
        System.out.println(f.exists());
        c45.train(f.getAbsolutePath());
        c45.j48Tree.setPrintNodeIndicators(true);
        System.out.println(c45.j48Tree.toString());
    }

    public void train(String inputArff) {
        Instances wekaTrainInstances;
        String trainFile = inputArff;
        try {
            this.arffLoader.setFile(new File(trainFile));
            wekaTrainInstances = this.arffLoader.getDataSet();
            wekaTrainInstances.setClass(wekaTrainInstances.attribute("play"));
        }
        catch (IOException e) {
            System.out.println("Error loading Arff files!");
            e.printStackTrace();
            return;
        }
        try {
            this.j48Tree.buildClassifier(wekaTrainInstances);
        }
        catch (Exception e) {
            System.out.println("J48 Unexpected Exception!");
            e.printStackTrace();
            return;
        }
    }

    public void setDefaultParameters() {
        this.j48Tree.setBinarySplits(false);
        this.j48Tree.setMinNumObj(1);
        this.j48Tree.setSaveInstanceData(false);
        this.j48Tree.setConfidenceFactor(0.25f);
        this.j48Tree.setReducedErrorPruning(false);
        this.j48Tree.setSubtreeRaising(true);
        this.j48Tree.setNumFolds(3);
        this.j48Tree.setUnpruned(false);
        this.j48Tree.setUseLaplace(false);
    }
}

