/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.SerializedObject;
import weka.core.pmml.DefineFunction;
import weka.core.pmml.DerivedFieldMetaInfo;

class TransformationDictionary
implements Serializable {
    protected ArrayList<DefineFunction> m_defineFunctions = new ArrayList();
    protected ArrayList<DerivedFieldMetaInfo> m_derivedFields = new ArrayList();

    protected TransformationDictionary(Element dictionary, Instances dataDictionary) throws Exception {
        ArrayList<Attribute> incomingFieldDefs = new ArrayList<Attribute>();
        int i = 0;
        while (i < dataDictionary.numAttributes()) {
            incomingFieldDefs.add(dataDictionary.attribute(i));
            ++i;
        }
        NodeList derivedL = dictionary.getChildNodes();
        int i2 = 0;
        while (i2 < derivedL.getLength()) {
            Node child = derivedL.item(i2);
            if (child.getNodeType() == 1) {
                String tagName = ((Element)child).getTagName();
                if (tagName.equals("DerivedField")) {
                    DerivedFieldMetaInfo df = new DerivedFieldMetaInfo((Element)child, incomingFieldDefs, null);
                    this.m_derivedFields.add(df);
                } else if (tagName.equals("DefineFunction")) {
                    DefineFunction defF = new DefineFunction((Element)child, null);
                    this.m_defineFunctions.add(defF);
                }
            }
            ++i2;
        }
    }

    protected void setFieldDefsForDerivedFields(ArrayList<Attribute> fieldDefs) throws Exception {
        int i = 0;
        while (i < this.m_derivedFields.size()) {
            this.m_derivedFields.get(i).setFieldDefs(fieldDefs);
            ++i;
        }
    }

    protected void setFieldDefsForDerivedFields(Instances fieldDefs) throws Exception {
        ArrayList<Attribute> tempDefs = new ArrayList<Attribute>();
        int i = 0;
        while (i < fieldDefs.numAttributes()) {
            tempDefs.add(fieldDefs.attribute(i));
            ++i;
        }
        this.setFieldDefsForDerivedFields(tempDefs);
    }

    protected ArrayList<DerivedFieldMetaInfo> getDerivedFields() {
        return new ArrayList<DerivedFieldMetaInfo>(this.m_derivedFields);
    }

    protected DefineFunction getFunction(String functionName) throws Exception {
        DefineFunction copy = null;
        DefineFunction match = null;
        for (DefineFunction f : this.m_defineFunctions) {
            if (!f.getName().equals(functionName)) continue;
            match = f;
            break;
        }
        if (match != null) {
            SerializedObject so = new SerializedObject(match, false);
            copy = (DefineFunction)so.getObject();
        }
        return copy;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Transformation dictionary:\n");
        if (this.m_derivedFields.size() > 0) {
            buff.append("derived fields:\n");
            for (DerivedFieldMetaInfo d : this.m_derivedFields) {
                buff.append(d.getFieldAsAttribute() + "\n");
            }
        }
        if (this.m_defineFunctions.size() > 0) {
            buff.append("\nfunctions:\n");
            for (DefineFunction f : this.m_defineFunctions) {
                buff.append(String.valueOf(f.toString("  ")) + "\n");
            }
        }
        buff.append("\n");
        return buff.toString();
    }
}

