/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.adx.complex;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.adx.ADXParams;
import dmLab.classifier.adx.complex.Complex;
import dmLab.classifier.adx.complex.ComplexList;
import dmLab.classifier.adx.selector.Selector;
import dmLab.classifier.adx.selector.SelectorList;
import dmLab.utils.ArrayUtils;
import dmLab.utils.list.IntegerList;
import java.util.Arrays;
import java.util.HashMap;

public final class ComplexSet {
    private ComplexList complexesList;
    private int complexSize;
    private HashMap<Integer, Integer> positionBySelectorId;
    private ADXParams cfg;
    public boolean verbose = false;

    public ComplexSet(SelectorList selectorsList, ADXParams adxParams, int attrNumber) {
        this.complexSize = 1;
        this.cfg = adxParams;
        this.complexesList = new ComplexList();
        int[] tempArray = new int[1];
        int selectorsListSize = selectorsList.size();
        int i = 0;
        while (i < selectorsListSize) {
            Selector tmpSelector = selectorsList.getSelector(i);
            tempArray[0] = i++;
            Complex tmpComplex = new Complex(tempArray);
            new Complex(tempArray).coverage = tmpSelector.coverage;
            tmpComplex.posCoverage = tmpSelector.posCoverage;
            tmpComplex.negCoverage = tmpSelector.negCoverage;
            tmpComplex.posSupport = tmpSelector.posSupport;
            tmpComplex.negSupport = tmpSelector.negSupport;
            tmpComplex.prepareToCoversFast(selectorsList, attrNumber);
            this.complexesList.add(tmpComplex);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ComplexSet(SelectorList selectorsList, ComplexSet prevComplexList, ADXParams params, int attrNumber) {
        void var2_2;
        void var1_1;
        void var3_3;
        this.cfg = var3_3;
        if (prevComplexList.size() > this.cfg.searchBeam) {
            prevComplexList.findSignificantQuality();
        }
        this.CreateSet$27998284((SelectorList)var1_1, (ComplexSet)var2_2, attrNumber);
    }

    private void CreateSet$27998284(SelectorList selectorsList, ComplexSet prevComplexList, int attrNumber) {
        boolean bl;
        ComplexSet complexSet = prevComplexList;
        this.complexSize = complexSet.complexSize + 1;
        this.complexesList = new ComplexList();
        int[] newSelectorsId = new int[this.complexSize];
        int prevListSize = prevComplexList.complexesList.size();
        complexSet = prevComplexList;
        int prevComplexSize = complexSet.complexSize;
        if (this.complexSize == 2) {
            int i = 0;
            while (i < prevListSize) {
                Complex complex_i = prevComplexList.getComplex(i);
                if (complex_i.reproduce) {
                    int j = i + 1;
                    while (j < prevListSize) {
                        Complex complex_j = prevComplexList.getComplex(j);
                        if (complex_j.reproduce && !complex_i.equalAttributes(complex_j, selectorsList)) {
                            int selPosition = 0;
                            while (selPosition < prevComplexSize) {
                                newSelectorsId[selPosition] = complex_i.getSelectorId(selPosition);
                                ++selPosition;
                            }
                            newSelectorsId[newSelectorsId.length - 1] = complex_j.getSelectorId(prevComplexSize - 1);
                            Complex newComplex = new Complex(newSelectorsId);
                            newComplex.setParentsCovs(complex_i.posCoverage, complex_i.negCoverage, complex_j.posCoverage, complex_j.negCoverage);
                            newComplex.prepareToCoversFast(selectorsList, attrNumber);
                            this.complexesList.add(newComplex);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return;
        }
        ComplexSet i = prevComplexList;
        if (i.complexSize < 2) {
            bl = false;
        } else {
            int complex_i = i.complexesList.size();
            i.positionBySelectorId = new HashMap();
            int j = -1;
            int complex_j = 0;
            while (complex_j < complex_i) {
                int newComplex = i.complexesList.get(complex_j).getSelectorId(0);
                if (newComplex != j) {
                    i.positionBySelectorId.put(newComplex, complex_j);
                    j = newComplex;
                }
                ++complex_j;
            }
            bl = true;
        }
        int i2 = 0;
        while (i2 < prevListSize) {
            Integer positionBySelector;
            Complex complex_i = prevComplexList.getComplex(i2);
            if (complex_i.reproduce && (positionBySelector = prevComplexList.positionBySelectorId.get(complex_i.idSelectors[1])) != null) {
                int complex_j_id = positionBySelector;
                Complex complex_j = prevComplexList.getComplex(complex_j_id);
                while (complex_j != null && complex_i.idSelectors[1] == complex_j.idSelectors[0]) {
                    if (complex_j.reproduce && complex_i.containsSubsequence(complex_j)) {
                        int selPosition = 0;
                        while (selPosition < prevComplexSize) {
                            newSelectorsId[selPosition] = complex_i.getSelectorId(selPosition);
                            ++selPosition;
                        }
                        newSelectorsId[newSelectorsId.length - 1] = complex_j.getSelectorId(prevComplexSize - 1);
                        Complex newComplex = new Complex(newSelectorsId);
                        newComplex.setParentsCovs(complex_i.posCoverage, complex_i.negCoverage, complex_j.posCoverage, complex_j.negCoverage);
                        newComplex.prepareToCoversFast(selectorsList, attrNumber);
                        this.complexesList.add(newComplex);
                    }
                    complex_j = prevComplexList.getComplex(++complex_j_id);
                }
            }
            ++i2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Complex getComplex(int index) {
        void var1_1;
        return this.complexesList.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeComplex(int index) {
        void var1_1;
        this.complexesList.remove((int)var1_1);
    }

    public final int size() {
        if (this.complexesList != null) {
            return this.complexesList.size();
        }
        return 0;
    }

    public final boolean trimList() {
        return this.complexesList.trim();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString(SelectorList selectorsList, FArray array) {
        void var3_3;
        StringBuffer tmp = new StringBuffer();
        tmp.append("#Complex Size: " + this.complexSize).append('\n');
        tmp.append("#Complexes Number: " + this.complexesList.size()).append('\n');
        int complexesListSize = this.complexesList.size();
        int i = 0;
        while (i < complexesListSize) {
            Complex tmpComplex = this.complexesList.get(i);
            StringBuilder stringBuilder = new StringBuilder(" ").append(tmpComplex.toString(selectorsList, array)).append('\t');
            Complex complex = tmpComplex;
            Object object = new StringBuffer();
            ((StringBuffer)object).append("p: " + DiscFunctions.formatFloat(complex.posCoverage, 3));
            ((StringBuffer)object).append(" n: " + DiscFunctions.formatFloat(complex.negCoverage, 3));
            ((StringBuffer)object).append(" c: " + DiscFunctions.formatFloat(complex.coverage, 3));
            ((StringBuffer)object).append(" ps: " + DiscFunctions.formatFloat(complex.posSupport, 3));
            ((StringBuffer)object).append(" ns: " + DiscFunctions.formatFloat(complex.negSupport, 3));
            tmp.append(stringBuilder.append(((StringBuffer)object).toString()).toString());
            StringBuilder stringBuilder2 = new StringBuilder(" ");
            object = this.cfg;
            complex = tmpComplex;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("q: " + DiscFunctions.formatFloat(complex.calcQuality(((ADXParams)object).qMethod), 4));
            stringBuffer.append(" qf: " + DiscFunctions.formatFloat(complex.calcQuality(((ADXParams)object).qMethodFinal), 4));
            tmp.append(stringBuilder2.append(stringBuffer.toString()).toString());
            StringBuilder stringBuilder3 = new StringBuilder(" ");
            complex = tmpComplex;
            object = new StringBuffer();
            ((StringBuffer)object).append("pr: " + DiscFunctions.formatFloat(complex.calcPosProbability(), 4));
            tmp.append(stringBuilder3.append(((StringBuffer)object).toString()).toString());
            tmp.append('\n');
            ++i;
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        int complexListSize = this.complexesList.size();
        int i = 0;
        while (i < complexListSize) {
            int j = 0;
            while (j < this.complexSize) {
                int n = j++;
                int n2 = i;
                ComplexSet complexSet = this;
                tmp.append(" " + complexSet.complexesList.get(n2).getSelectorId(n));
            }
            tmp.append('\n');
            ++i;
        }
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean evaluate$1594a9c8(FArray array, int decisionValIndex) {
        int interval;
        if (this.complexesList.size() == 0) {
            return false;
        }
        int eventsNumber = array.rowsNumber();
        int complexesListSize = this.complexesList.size();
        float complexesListSizeDbl = this.complexesList.size();
        int decAttrIndex = array.getDecAttrIdx();
        float decisionValue = array.getDecValues()[decisionValIndex];
        int threshold = interval = (int)Math.ceil(0.1 * (double)complexesListSize);
        int totalPos = array.getADXDomain(decAttrIndex).getTotalPositives(decisionValIndex);
        int totalNeg = array.getADXDomain(decAttrIndex).getTotalNegatives(decisionValIndex);
        if (this.verbose) {
            System.out.print("Progress: ");
        }
        int i = 0;
        while (i < complexesListSize) {
            void var3_13;
            void var2_2;
            int complexPosSupport = 0;
            int complexNegSupport = 0;
            Complex complex = this.complexesList.get(i);
            int j = 0;
            while (j < eventsNumber) {
                if (complex.coversFast(array, j)) {
                    if (array.readValue(decAttrIndex, j) == decisionValue) {
                        ++complexPosSupport;
                    } else {
                        ++complexNegSupport;
                    }
                }
                ++j;
            }
            complex.posCoverage = (float)complexPosSupport / (float)totalPos;
            complex.negCoverage = (float)complexNegSupport / (float)totalNeg;
            complex.coverage = (float)(complexPosSupport + complexNegSupport) / (float)eventsNumber;
            complex.posSupport = (float)var2_2;
            complex.negSupport = (float)var3_13;
            if (i > threshold && threshold != 0) {
                if (this.verbose) {
                    System.out.print((int)(100.0 * (double)i / (double)complexesListSizeDbl) + "% ");
                }
                threshold += interval;
            }
            ++i;
        }
        if (this.verbose) {
            System.out.println("100% ");
        }
        return true;
    }

    public final int cleanCandidatesSet(SelectorList selectorsList, ADXParams adxParams) {
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        int i = 0;
        while (i < listSize) {
            Complex complex = this.complexesList.get(i);
            if ((double)complex.posCoverage == 0.0) {
                this.complexesList.remove(i);
                ++removed;
            } else if (adxParams.cleanCandidates == 1) {
                if (!complex.betterThanSubSelectors_Q(selectorsList, this.cfg.qMethod)) {
                    this.complexesList.remove(i);
                    ++removed;
                }
            } else if (adxParams.cleanCandidates == 2 && !complex.betterThanParents_Q(this.cfg.qMethod)) {
                this.complexesList.remove(i);
                ++removed;
            }
            ++i;
        }
        this.complexesList.trim();
        return removed;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesPosLessNeg() {
        void var2_2;
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        int i = 0;
        while (i < listSize) {
            Complex complex;
            Complex complex2 = this.complexesList.get(i);
            if (complex.posCoverage <= complex2.negCoverage) {
                this.complexesList.remove(i);
                ++removed;
            }
            ++i;
        }
        this.complexesList.trim();
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final int deleteComplexesCoversNeg() {
        void var2_2;
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        int i = 0;
        while (i < listSize) {
            if ((double)this.complexesList.get((int)i).negCoverage > 0.0) {
                this.complexesList.remove(i);
                ++removed;
            }
            ++i;
        }
        this.complexesList.trim();
        return (int)var2_2;
    }

    public final int deleteComplexesQLess(double minQuality) {
        int listSize = this.complexesList.size();
        if (listSize == 0) {
            return -1;
        }
        int removed = 0;
        int i = 0;
        while (i < listSize) {
            if (this.getComplex(i).calcQuality(this.cfg.qMethod) < minQuality) {
                this.complexesList.remove(i);
                ++removed;
            }
            ++i;
        }
        this.complexesList.trim();
        return removed;
    }

    public final int selectComplexesToReproduce(double minQuality) {
        int listSize = this.complexesList.size();
        int toReproduce = 0;
        IntegerList minQualityIDs = new IntegerList();
        int i = 0;
        while (i < listSize) {
            Complex complex = this.complexesList.get(i);
            double complexQuality = complex.calcQuality(this.cfg.qMethod);
            if ((this.cfg.complexGenerality != 1 || (double)complex.negCoverage != 0.0) && complexQuality >= minQuality) {
                complex.reproduce = true;
                ++toReproduce;
                if (complexQuality == minQuality) {
                    minQualityIDs.add(i);
                }
            } else {
                complex.reproduce = false;
            }
            ++i;
        }
        if (toReproduce > this.cfg.searchBeam) {
            int toThrow = toReproduce - this.cfg.searchBeam;
            int[] throwArray = new int[minQualityIDs.size()];
            ArrayUtils arrayUtils = new ArrayUtils();
            arrayUtils.randomFill(throwArray, toThrow, 1, 0);
            int i2 = 0;
            while (i2 < throwArray.length) {
                if (throwArray[i2] == 1) {
                    this.complexesList.get((int)minQualityIDs.get((int)i2)).reproduce = false;
                    --toReproduce;
                }
                ++i2;
            }
        }
        return toReproduce;
    }

    /*
     * WARNING - void declaration
     */
    public final double findSignificantQuality() {
        void var2_2;
        void var1_1;
        double[] significantQ = new double[this.cfg.searchBeam];
        Arrays.fill(significantQ, Double.NEGATIVE_INFINITY);
        int minValuePosition = significantQ.length;
        int listSize = this.complexesList.size();
        int i = 0;
        while (i < listSize) {
            Complex complex = this.complexesList.get(i);
            if (complex.reproduce) {
                double complexQuality = complex.calcQuality(this.cfg.qMethod);
                if (minValuePosition > 0) {
                    significantQ[--minValuePosition] = complexQuality;
                } else if (complexQuality >= significantQ[0]) {
                    significantQ[0] = complexQuality;
                    Arrays.sort(significantQ);
                }
            }
            ++i;
        }
        Arrays.sort(significantQ);
        if (minValuePosition >= significantQ.length) {
            System.out.println("significantQ: " + Arrays.toString(significantQ));
            return Double.NEGATIVE_INFINITY;
        }
        return (double)var1_1[var2_2];
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public final boolean mergeComplexes(SelectorList selectorsList, FArray array) {
        int n;
        int listSize = this.complexesList.size();
        int currentIndex = 0;
        if (listSize == 0) {
            return false;
        }
        int i = 0;
        while (n < listSize - 1) {
            boolean bl;
            Complex complex = this.complexesList.get(i);
            if (complex == null) {
                ++i;
                continue;
            }
            int stopIndex = i + 1;
            boolean bl2 = true;
            do {
                if (!bl2 || (bl2 = false) || !true) {
                    ++stopIndex;
                }
                if (stopIndex >= listSize || !complex.mergingPossible(selectorsList, this.complexesList.get(stopIndex), array)) break;
                ADXParams aDXParams = this.cfg;
                Complex complex2 = this.complexesList.get(stopIndex);
                Complex complex3 = complex;
                if (aDXParams.mergeCondition != 0) {
                    if (aDXParams.mergeCondition == 1) {
                        bl = true;
                        continue;
                    }
                    if (aDXParams.mergeCondition == 2) {
                        double d = DiscFunctions.calc(complex3.posCoverage, complex3.negCoverage, aDXParams.qMethod);
                        double d2 = DiscFunctions.calc(complex2.posCoverage, complex2.negCoverage, aDXParams.qMethod);
                        double d3 = DiscFunctions.calc(complex3.posCoverage + complex2.posCoverage, complex3.negCoverage + complex2.negCoverage, aDXParams.qMethod);
                        if (d3 > d || d3 > d2) {
                            bl = true;
                            continue;
                        }
                    }
                }
                bl = false;
            } while (bl);
            boolean bl3 = true;
            do {
                block16: {
                    block15: {
                        if (!bl3 || (bl3 = false)) break block15;
                        if (currentIndex >= stopIndex) continue;
                        if (true) break block16;
                    }
                    if (complex.merge(selectorsList, this.getComplex(currentIndex), array)) {
                        this.removeComplex(currentIndex++);
                        continue;
                    }
                    if (complex.contains(selectorsList, this.getComplex(currentIndex), array)) {
                        this.removeComplex(currentIndex);
                    } else {
                        System.err.println("Error. Complexes have not been merged.\n\t" + complex.toString(selectorsList, array) + "\n\t" + this.getComplex(currentIndex).toString(selectorsList, array));
                    }
                }
                ++currentIndex;
            } while (currentIndex < stopIndex);
            n = stopIndex;
        }
        this.complexesList.trim();
        return true;
    }
}

