/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.cutoffMethods;

import dmLab.array.functions.DiscFunctions;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.measuresRI.Importance;
import dmLab.mcfs.cutoffMethods.CutoffMethod;
import java.util.Arrays;

public final class ContrastCutoff
extends CutoffMethod {
    /*
     * WARNING - void declaration
     */
    public ContrastCutoff(MCFSParams mcfsParams) {
        super((MCFSParams)var1_1);
        void var1_1;
        this.name = "contrast";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final double getCutoff(Importance[] importance) {
        void var3_6;
        int size = 0;
        int i = 0;
        while (i < importance.length) {
            if (importance[i].name.startsWith(MCFSParams.CONTRAST_ATTR_NAME)) {
                ++size;
            }
            ++i;
        }
        if (size == 0) {
            return Double.NaN;
        }
        double[] values = new double[size];
        int i2 = 0;
        int j = 0;
        while (i2 < importance.length) {
            if (importance[i2].name.startsWith(MCFSParams.CONTRAST_ATTR_NAME)) {
                values[j++] = importance[i2].importance;
            }
            ++i2;
        }
        void var2_4 = var3_6;
        ContrastCutoff contrastCutoff = this;
        double d = Double.NaN;
        Arrays.sort((double[])var2_4);
        int n = Math.max(Math.round((float)((void)var2_4).length * contrastCutoff.mcfsParams.contrastCutoff), 1);
        if (n <= 0 || n > ((void)var2_4).length) {
            System.out.println("Invalid mcfsParams.contrastAttrThreshold value, ignoring cutoff.");
        } else {
            d = var2_4[((void)var2_4).length - n];
            System.out.println("Minimal (based on contrast attributes) RI = " + DiscFunctions.formatFloat(d, 7));
        }
        return d;
    }
}

