/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.classifier.PredictionResult;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.experiment.classification.ClassificationParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.utils.ArrayUtils;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;
import dmLab.utils.dataframe.DataFrame;
import java.util.Random;

public final class MCFSFinalCV {
    private int[] algorithms;
    private Random random;
    private ArrayUtils arrayUtils;
    public ConfusionMatrix[] j48ConfMatrix;
    private ConfusionMatrix j48ConfMatrixTmp;

    /*
     * WARNING - void declaration
     */
    public MCFSFinalCV(int[] algorithms, Random random) {
        void var2_2;
        void var1_1;
        this.algorithms = var1_1;
        this.random = random;
        this.arrayUtils = new ArrayUtils((Random)var2_2);
    }

    public final DataFrame run(FArray array, AttributesRI importances, int[] size, int cvFolds, int setSize, int repetitions) {
        this.j48ConfMatrix = new ConfusionMatrix[size.length];
        if (array.rowsNumber() <= setSize) {
            repetitions = 1;
        }
        DataFrame result_df = null;
        int i = 0;
        while (i < size.length) {
            int currSize = size[i];
            if (currSize > 0) {
                FArray fArray = array;
                if (currSize < fArray.attributes.length) {
                    int[] colIdx = DiscFunctions.getColumnsIdx(array, importances, currSize);
                    int[] rowIdx = ArrayUtils.seq(0, array.rowsNumber());
                    DataFrame step_df = null;
                    int j = 0;
                    while (j < repetitions) {
                        FArray rep_array = array.cloneByIdx(colIdx, this.arrayUtils.randomSelectValues(rowIdx, setSize));
                        if (repetitions > 1) {
                            fArray = rep_array;
                            System.out.println("*** CV Repetition = " + (j + 1) + " [" + rep_array.rowsNumber() + " x " + fArray.attributes.length + "]");
                        }
                        DataFrame rep_df = this.singleCV(rep_array, Integer.toString(currSize), cvFolds);
                        this.j48ConfMatrix[i] = this.j48ConfMatrixTmp;
                        if (step_df == null) {
                            step_df = rep_df;
                        } else {
                            step_df.mathOperation(rep_df, "+");
                        }
                        ++j;
                    }
                    step_df.mathOperation(repetitions, "/");
                    if (result_df == null) {
                        result_df = step_df;
                    } else {
                        result_df.rbind(step_df);
                    }
                }
            }
            ++i;
        }
        this.j48ConfMatrixTmp = null;
        return result_df;
    }

    /*
     * WARNING - void declaration
     */
    private DataFrame singleCV(FArray array, String label, int cvFolds) {
        DataFrame df;
        this.j48ConfMatrixTmp = null;
        if (array.isTargetNominal()) {
            df = new DataFrame(this.algorithms.length, new String[]{"label", "algorithm", "acc", "wacc"});
            short[] sArray = new short[4];
            sArray[2] = 1;
            sArray[3] = 1;
            df.setColTypes(sArray);
        } else {
            df = new DataFrame(this.algorithms.length, new String[]{"label", "algorithm", "pearson", "MAE", "RMSE", "SMAPE"});
            short[] sArray = new short[6];
            sArray[2] = 1;
            sArray[3] = 1;
            sArray[4] = 1;
            sArray[5] = 1;
            df.setColTypes(sArray);
        }
        ClassificationBody classification = new ClassificationBody(this.random);
        classification.setParameters(new ClassificationParams());
        classification.classParams.verbose = false;
        classification.classParams.saveClassifier = false;
        classification.classParams.savePredictionResult = false;
        classification.classParams.folds = cvFolds;
        classification.classParams.repetitions = 1;
        int i = 0;
        while (i < this.algorithms.length) {
            classification.classParams.model = this.algorithms[i];
            classification.initClassifier();
            if (i == 0) {
                System.out.print("Evaluating model performance using " + cvFolds + " fold CV. Model: " + Classifier.int2label(this.algorithms[i]));
            } else {
                System.out.print(", " + Classifier.int2label(this.algorithms[i]));
            }
            PredictionResult predResult = classification.runCV(array);
            df.set(i, 0, label);
            df.set(i, 1, Classifier.int2label(this.algorithms[i]));
            if (array.isTargetNominal()) {
                ConfusionMatrix matrix = predResult.confusionMatrix;
                if (this.algorithms[i] == Classifier.J48) {
                    this.j48ConfMatrixTmp = matrix;
                }
                df.set(i, 2, Float.valueOf(matrix.calcMeasure(QualityMeasure.ACC)));
                df.set(i, 3, Float.valueOf(matrix.calcMeasure(QualityMeasure.WACC)));
            } else {
                void var7_7;
                df.set(i, 2, Float.valueOf((float)var7_7.getPredQuality(QualityMeasure.PEARSON)));
                df.set(i, 3, Float.valueOf((float)var7_7.getPredQuality(QualityMeasure.MAE)));
                df.set(i, 4, Float.valueOf((float)var7_7.getPredQuality(QualityMeasure.RMSE)));
                df.set(i, 5, Float.valueOf((float)var7_7.getPredQuality(QualityMeasure.SMAPE)));
            }
            ++i;
        }
        System.out.println();
        return df;
    }
}

