% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdf_article.R
\name{pdf_article}
\alias{pdf_article}
\title{Rmarkdown template for an augmented version of the basic pandoc latex
template}
\usage{
pdf_article(..., number_sections = TRUE,
  md_extensions = c("-autolink_bare_uris"), indent = TRUE,
  marginals = TRUE, author_block = TRUE, noindentafter = TRUE,
  subfigs = TRUE, template = NULL, csl = NULL, colorlinks = TRUE)
}
\arguments{
\item{...}{arguments passed down to [bookdown::pdf_document2()]}

\item{number_sections}{whether sections should be numbered}

\item{md_extensions}{which markdown extensions to add}

\item{indent}{whether to use paragraph indentation or not. In the latter case
paragraphs are separated by vertical space as in the default rmarkdown
template.}

\item{marginals}{whether to augment latex template with marginals (header
and footer) code}

\item{author_block}{whether to augment latex template with author
blocks. The latex package authblk is required.}

\item{noindentafter}{whether to augment latex template with
the noindentafter latex package to suppress indentation after
certain environments. Always set to `FALSE` is `indent = FALSE`.}

\item{subfigs}{whether to use the subfig package for subfig support}

\item{template}{template for latex output. If `NULL`, the default
latex template will be used (obtained from calling `pandoc -D latex`).}

\item{csl}{bibliography style in the `.csl` format}

\item{colorlinks}{should cross-references and links be
colored?}
}
\value{
R Markdown output format to pass to [rmarkdown::render()]
}
\description{
Rmarkdown template for an augmented version of the basic pandoc latex
template
}
\examples{
library(rmarkdown)
library(bookdown)
tmp <- file.path(tempdir(), "my-article.Rmd")
rmarkdown::draft(tmp,
                 template = "pdf_article",
                 package = "rmdplugr",
                 edit = FALSE)
unlink(tmp)
}
