% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Model.R
\name{Model}
\alias{Model}
\title{MiniZinc Model class}
\description{
This class will take all the objects required to create a MiniZinc model.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.items}}{list of items in the model}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.items}}{list of items in the model}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Model$new()}}
\item \href{#method-getItems}{\code{Model$getItems()}}
\item \href{#method-setItems}{\code{Model$setItems()}}
\item \href{#method-getItem}{\code{Model$getItem()}}
\item \href{#method-setItem}{\code{Model$setItem()}}
\item \href{#method-addItem}{\code{Model$addItem()}}
\item \href{#method-nitems}{\code{Model$nitems()}}
\item \href{#method-mzn_string}{\code{Model$mzn_string()}}
\item \href{#method-clone}{\code{Model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
create a new instance of model class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$new(items)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{all items of the model}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getItems"></a>}}
\if{latex}{\out{\hypertarget{method-getItems}{}}}
\subsection{Method \code{getItems()}}{
get all the items
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getItems()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setItems"></a>}}
\if{latex}{\out{\hypertarget{method-setItems}{}}}
\subsection{Method \code{setItems()}}{
set all the items
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$setItems(items)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{items to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getItem"></a>}}
\if{latex}{\out{\hypertarget{method-getItem}{}}}
\subsection{Method \code{getItem()}}{
get the item using index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$getItem(i)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setItem"></a>}}
\if{latex}{\out{\hypertarget{method-setItem}{}}}
\subsection{Method \code{setItem()}}{
set the item using index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$setItem(i, item)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{index}

\item{\code{item}}{item to be set}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addItem"></a>}}
\if{latex}{\out{\hypertarget{method-addItem}{}}}
\subsection{Method \code{addItem()}}{
add item to the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$addItem(item)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{item}}{item to add}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nitems"></a>}}
\if{latex}{\out{\hypertarget{method-nitems}{}}}
\subsection{Method \code{nitems()}}{
get the number of items
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$nitems()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-mzn_string"></a>}}
\if{latex}{\out{\hypertarget{method-mzn_string}{}}}
\subsection{Method \code{mzn_string()}}{
get the string representation of the model
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$mzn_string()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
