% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{nassqs_GET}
\alias{nassqs_GET}
\title{Issue a GET request to the NASS 'Quick Stats' API}
\usage{
nassqs_GET(..., api_path = c("api_GET", "get_param_values",
  "get_counts"))
}
\arguments{
\item{...}{either a named list of parameters or a series of parameters to
use in the query}

\item{api_path}{the API path that determines the type of request being made}
}
\value{
a \code{\link[httr:GET]{httr::GET()}} response object
}
\description{
This is the workhorse of the package that provides the core request
functionality to the NASS 'Quick Stats' API:
\url{https://quickstats.nass.usda.gov/api}.
In most cases \code{\link[=nassqs]{nassqs()}} or other high-level functions should be used.
\code{nassqs_GET()} uses \code{\link[httr:GET]{httr::GET()}} to make a HTTP GET request, which returns a
request object which must then be parsed to a data.frame, list, or other \code{R}
object. Higher-level functions will do that parsing automatically. However,
if you need access to the request object directly, \code{nassqs_GET()} provides
that.
}
\examples{
\donttest{
  # Yields for corn in 2012 in Washington
  params <- list(commodity_name = "CORN",
                 year = 2012,
                 agg_level_desc = "STATE",
                 state_alpha = "WA",
                 statisticcat_desc = "YIELD")

  # Returns a request object that must be parsed either manually or
  # by using nassqs_parse()
  response <- nassqs_GET(params)
  yields <- nassqs_parse(response)
  head(yields)

  # Get the number of records that would be returned for a given request
  # Equivalent to 'nassqs_record_count(params)'
  response <- nassqs_GET(params, api_path = "get_counts")
  records <- nassqs_parse(response)
  records

  # Get the list of allowable values for the parameters 'statisticcat_desc'
  # Equivalent to 'nassqs_param_values("statisticcat_desc")'
  req <- nassqs_GET(list(param = "statisticcat_desc"),
                    api_path = "get_param_values")
  statisticcat_desc_values <- nassqs_parse(req, as = "list")
  head(statisticcat_desc_values)
}
}
