% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/league.heatmap_function.R
\name{league_heatmap}
\alias{league_heatmap}
\title{League heatmap for estimation}
\usage{
league_heatmap(full, cov_value = NULL, drug_names)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}} for network
meta-analysis or \code{\link{run_metareg}} for network meta-regression.
See 'Value' in \code{\link{run_model}} and \code{\link{run_metareg}}.}

\item{cov_value}{A list of two elements in the following order: a number
for the covariate value of interest and a character for the name of the
covariate. See also 'Details'.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}
}
\value{
A heatmap of the league table showing the posterior mean and 95\%
  credible interval for all possible comparisons in the off-diagonals, and
  the posterior mean of the SUCRA values in the diagonal.
}
\description{
Provides a heatmap of the estimated effect measure for all possible
  comparisons of interventions in the network. \code{league_heatmap} can be
  used for a random-effects or fixed-effect network meta-analysis and network
   meta-regression. It is applied for one outcome only.
}
\details{
The rows and columns of the heatmap display the names of
  interventions  sorted by decreasing order from the best to the worst
  based on their SUCRA value (Salanti et al., 2011). The off-diagonals
  contain the posterior mean and 95\% credible interval of the effect measure
  (according to the argument \code{measure} defined in
  \code{\link{run_model}}) of the corresponding comparisons.

  The main diagonal contains the posterior mean of SUCRA of the corresponding
  interventions when the argument \code{full} refers to the
  \code{\link{run_model}} function. When the argument \code{full} refers to
  the \code{\link{run_metareg}} function, the p-score
  (Ruecker and Schwarzer, 2015) is calculated for each intervention while
  taking into account the covariate value in the argument \code{cov_value}.
  P-score is the 'frequentist analogue to SUCRA'
  (Ruecker and Schwarzer, 2015).

  Results in the lower triangle refer to comparisons in the opposite
  direction after converting negative values into positive values
  (in absolute or logarithmic scale), and vice versa. Darker shades of red
  and blue correspond to larger treatment effects in the upper and lower
  triangle, respectively, for a beneficial outcome, and vice versa for a
  harmful outcome. Odds ratios and ratio of means are reported in the
  original scale after exponentiation of the logarithmic scale.

  Comparisons between interventions should be read from left to right.
  Therefore, each cell refers to the corresponding row-defining intervention
  against the column-defining intervention.
  Results that indicate strong evidence in favour of the row-defining
  intervention (i.e. the respective 95\% credible interval does not include
  the null value) are indicated in bold.

  In the case of network meta-regression, when the covariate is binary,
  specify in the second element of \code{cov_value} the name of the level
  for which the heatmap will be created.

  \code{league_heatmap} can be used only for a network of interventions.
  In the case of two interventions, the execution of the function will be
  stopped and an error message will be printed on the R console.
}
\examples{
data("nma.liu2013")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_liu.rds', package = 'rnmamod'))

# The names of the interventions in the order they appear in the dataset
interv_names <- c("placebo", "pramipexole", "serotonin-norepinephrine
                  reuptake inhibitor", "serotonin reuptake inhibitor",
                  "tricyclic antidepressant", "pergolide")

# Create the league heatmap
league_heatmap(full = res,
               drug_names = interv_names)

}
\references{
Ruecker G, Schwarzer G. Ranking treatments in frequentist network
meta-analysis works without resampling methods.
\emph{BMC Med Res Methodol} 2015;\bold{15}:58.
\doi{10.1186/s12874-015-0060-8}

Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
\doi{10.1016/j.jclinepi.2010.03.016}
}
\seealso{
\code{\link{run_metareg}}, \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}, {Chrysostomos Kalyvas},
  {Katerina Papadimitropoulou}
}
