% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.diagnostics_function.R
\name{mcmc_diagnostics}
\alias{mcmc_diagnostics}
\title{Markov Chain Monte Carlo diagnostics}
\usage{
mcmc_diagnostics(net, par = NULL)
}
\arguments{
\item{net}{An object of S3 class \code{\link{run_metareg}},
\code{\link{run_model}}, \code{\link{run_nodesplit}},
\code{\link{run_sensitivity}}, \code{\link{run_series_meta}}, and
\code{\link{run_ume}}. See 'Value' in the functions above.}

\item{par}{A vector of three character strings that refer to three monitored
parameters in \code{jagsfit} which is an object of S3 class
\code{\link{run_metareg}}, \code{\link{run_model}}, and
\code{\link{run_ume}}. These three selected parameters will be
considered in the diagnostic plots (see 'Value'). This argument will be
ignored for objects of S3 class \code{\link{run_nodesplit}},
\code{\link{run_sensitivity}}, and \code{\link{run_series_meta}}.}
}
\value{
\code{mcmc_diagnostics} returns a data-frame that contains the
  Gelman-Rubin convergence diagnostic, \strong{R-hat}, the MCMC error, and
  the convergence status of the following monitored parameters:
  \code{EM} {The estimated summary effect measure.}
  \code{EM_pred} {The predicted summary effect measure.}
  \code{delta} {The estimated trial-specific effect measure.}
  \code{tau} {The between-trial standard deviation.}
  \code{direct} {The direct estimate of the split node (see 'Value' in
  \code{\link{run_nodesplit}}).}
  \code{indirect} {The indirect estimate of the split node
  (see 'Value' in \code{\link{run_nodesplit}}).}
  \code{diff} {The inconsistency factor of the split node (see 'Value' in
  \code{\link{run_nodesplit}}).}
  \code{phi} {The informative missingness parameter.}
  \code{beta} {The regression coefficient.}

  \code{mcmc_diagnostics} also uses the
  \code{\link[mcmcplots:mcmcplot]{mcmcplot}} function of the R-package
  \href{https://CRAN.R-project.org/package=mcmcplots}{mcmcplots} to create an
  HTML file with a panel of diagnostic plots (trace, density, and
  autocorrelation) for each monitored parameter.
}
\description{
Evaluates whether convergence has been achieved for the
  monitored parameters of the Bayesian models. The Gelman-Rubin convergence
  diagnostic, the Markov Chain Monte Carl (MCMC) error and relevant
  diagnostic plots are applied.
}
\details{
For each monitored parameter, \code{mcmc_diagnostics} considers the
  maximum R-hat and MCMC error and compares them with the thresholds 1.1
  and 5\%, respectively. Convergence is achieved for the monitored parameter,
  when the maximum R-hat and MCMC error are below the corresponding
  thresholds; otherwise, the MCMC algorithm has not converged for that
  parameter. If the monitored parameter is a vector with the posterior
  results, there is only one R-hat and one MCMC error. If the monitored
  parameter is a matrix of the posterior results, there are as many R-hats
  and MCMC errors as the number of rows for that parameter. In that case, the
  maximum R-hat and MCMC error are considered.
}
\examples{
data("nma.baker2009")

# Read results from 'run_nodesplit' (using the default arguments)
res <- readRDS(system.file('extdata/node_baker.rds', package = 'rnmamod'))

# Check convergence based on R-hat
mcmc_diagnostics(net = res,
                 par = c("tau", "EM[2,1]", "EM.pred[2,1]"))

}
\references{
Gelman, A, Rubin, DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}(4):457--72.
doi: 10.1214/ss/1177011136
}
\seealso{
\code{\link[mcmcplots:mcmcplot]{mcmcplot}},
  \code{\link{run_metareg}}, \code{\link{run_model}},
  \code{\link{run_nodesplit}}, \code{\link{run_sensitivity}},
  \code{\link{run_series_meta}}, \code{\link{run_ume}}
}
\author{
{Loukia M. Spineli}
}
