% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baseline.model_function.R
\name{baseline_model}
\alias{baseline_model}
\title{The baseline model for binary outcome}
\usage{
baseline_model(base_risk, n_chains, n_iter, n_burnin, n_thin)
}
\arguments{
\item{base_risk}{A scalar, a vector of length three with elements sorted in
ascending order, or a matrix with two columns and number of rows equal to
the number of relevant trials. In the case of a scalar or vector, the
elements should be in the interval (0, 1). For the matrix, the first column
refers to the number of events and the second column to the sample size of
the trials comprising the dataset for the baseline model. See 'Details' in
\code{\link{run_model}}.
This argument is only relevant for a binary outcome.}

\item{n_chains}{Positive integer specifying the number of chains for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 2.}

\item{n_iter}{Positive integer specifying the number of Markov chains for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 10000.}

\item{n_burnin}{Positive integer specifying the number of iterations to
discard at the beginning of the MCMC sampling; an argument of the
\code{\link[R2jags:jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1000.}

\item{n_thin}{Positive integer specifying the thinning rate for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1.}
}
\value{
When \code{base_risk} is scalar (fixed baseline), the function
  returns the user-defined baseline for the selected reference intervention.
  When \code{base_risk} is a vector (random baseline), the function returns
  a vector with the calculated logit of an event for the selected reference
  intervention and its precision. Finally, when \code{base_risk} is a matrix
  (predicted baseline), the function returns the following elements:
  \item{ref_base}{A vector with the posterior mean and precision of the
  predicted logit of an event for the selected reference intervention.
  This vector is be passed to \code{\link{run_model}} and
  \code{\link{run_metareg}}.}
  \item{mean_base_logit}{The posterior distribution of the summary mean of
  the random effects in the logit scale.}
  \item{tau_base_logit}{The posterior distribution of the between-trial
  standard deviation in the logit scale.}

  When \code{base_risk} is a matrix, the function also returns a forest plot
  with the estimated trial-specific probability of an event and 95\% credible
  intervals (the random effects) alongside the corresponding observed
  probability of an event for the selected reference intervention. A grey
  rectangular illustrates the summary mean and 95\% credible interval of the
  random effects.
}
\description{
To process the elements in the argument \code{base_risk} of the
  \code{\link{run_model}} function. It also runs the hierarchical baseline
  model, separately from the relative effects model as described in
  Dias et al. (2018) and Dias et al. (2013b). The output is to be passed to
  \code{\link{run_model}} and \code{\link{run_metareg}} to obtain the
  (unadjusted and adjusted, respectively) absolute risks for each
  intervention in the dataset.
}
\details{
If \code{base_risk} is a matrix, \code{baseline_model} creates the
  hierarchical baseline model in the JAGS dialect of the BUGS language.
  The output of this function (see 'Value') constitutes the
  posterior mean and precision of the predicted logit of an event for the
  selected reference intervention and it is plugged in the WinBUGS code for
  the relative effects model (Dias et al., 2013a) via the
  \code{\link{prepare_model}} function. Following (Dias et al., 2013a), a
  uniform prior distribution is assigned on the between-trial standard
  deviation with upper and lower limit equal to 0 and 5, respectively.
}
\references{
Dias S, Ades AE, Welton NJ, Jansen JP, Sutton AJ. Network Meta-Analysis for
Decision Making. Chichester (UK): Wiley; 2018.

Dias S, Sutton AJ, Ades AE, Welton NJ. Evidence synthesis for decision
making 2: a generalized linear modeling framework for pairwise and network
meta-analysis of randomized controlled trials. \emph{Med Decis Making}
2013a;\bold{33}(5):607--17. doi: 10.1177/0272989X12458724

Dias S, Welton NJ, Sutton AJ, Ades AE. Evidence synthesis for decision
making 5: the baseline natural history model. \emph{Med Decis Making}
2013b;\bold{33}(5):657--70. doi: 10.1177/0272989X13485155
}
\seealso{
\code{\link{prepare_model}}, \code{\link[R2jags:jags]{jags}},
  \code{\link{run_metareg}}, \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
