% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dendro.heatmap_function.R
\name{dendro_heatmap}
\alias{dendro_heatmap}
\title{Dendrogram with amalgamated heatmap
(Comparisons' comparability for transitivity evaluation)}
\usage{
dendro_heatmap(input, label_size = 12, axis_text_size = 10)
}
\arguments{
\item{input}{An object of S3 class \code{\link{comp_clustering}}. See 'Value'
in \code{\link{comp_clustering}}.}

\item{label_size}{A positive integer for the font size of the heatmap
elements. \code{label_size} determines the size argument found in the
geom's aesthetic properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}

\item{axis_text_size}{A positive integer for the font size of row and column
names of the heatmap. \code{axis_text_size} determines the axis.text
argument found in the theme's properties in the R-package
\href{https://CRAN.R-project.org/package=ggplot2}{ggplot2}.}
}
\value{
\code{dendro_heatmap} uses the \code{\link[heatmaply:heatmaply]{heatmaply}}
   function of the R-package
  \href{https://CRAN.R-project.org/package=heatmaply}{heatmaply} to create a
  cluster heatmap for a selected linkage method and number of clusters. The
  function uses different colours to indicate the clusters directly on the
  dendrogram, specified using the R-package
  \href{https://CRAN.R-project.org/package=dendextend}{dendextend}. The names
  of the leaves refer to the trials and corresponding pairwise comparison.

 @details
   The function inherits the linkage method and number of optimal clusters by
   the \code{\link{comp_clustering}} function.

   Remember: when using the \code{\link{comp_clustering}} function, inspect
   the average silhouette width for a wide range of clusters to decide on the
   optimal number of clusters.
}
\description{
\code{dendro_heatmap} creates a dendrogram alongside the heatmap of
  Gower dissimilarities among the trials in the network for a specific
  linkage method and number of clusters.
}
\examples{
\donttest{
# Fictional dataset
data_set <- data.frame(Trial_name = as.character(1:7),
                      arm1 = c("1", "1", "1", "1", "1", "2", "2"),
                      arm2 = c("2", "2", "2", "3", "3", "3", "3"),
                      sample = c(140, 145, 150, 40, 45, 75, 80),
                      age = c(18, 18, 18, 48, 48, 35, 35),
                      blinding = factor(c("yes", "yes", "yes", "no", "no", "no", "no")))

# Apply hierarchical clustering (informative = FALSE)
hier <- comp_clustering(input = data_set,
                        drug_names = c("A", "B", "C"),
                        threshold = 0.13,  # General research setting
                        informative = FALSE,
                        optimal_clusters = 3,
                        get_plots = TRUE)

# Create the dendrogram with integrated heatmap
dendro_heatmap(hier)
}

}
\seealso{
\code{\link{comp_clustering}}, \code{\link[heatmaply:heatmaply]{heatmaply}}
}
\author{
{Loukia M. Spineli}
}
