% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.factanal.R
\name{biplot.factanal}
\alias{biplot.factanal}
\title{Biplot method}
\usage{
\method{biplot}{factanal}(x, ...)
}
\arguments{
\item{x}{object of class \sQuote{factanal}}

\item{\dots}{...}
}
\value{
The robust compositional biplot.
}
\description{
Provides robust compositional biplots.
}
\details{
The robust compositional biplot according to Aitchison and Greenacre (2002),
computed from resulting (robust) loadings and scores, is performed.
}
\examples{
data(expenditures)
res.rob <- pfa(expenditures, factors=2, scores = "regression")
biplot(res.rob)
}
\references{
Aitchison, J. and Greenacre, M. (2002). Biplots of compositional
data. \emph{Applied Statistics}, \bold{51}, 375-392. \

Filzmoser, P., Hron, K., Reimann, C. (2009) Principal Component Analysis for
Compositional Data with Outliers. \emph{Environmetrics}, \bold{20} (6),
621--632.
}
\seealso{
\code{\link{pfa}}
}
\author{
M. Templ, K. Hron
}
\keyword{aplot}
