% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{expenditures}
\alias{expenditures}
\title{synthetic household expenditures toy data set}
\format{
A data frame with 20 observations on the following 5 variables.
}
\usage{
data(expenditures)
}
\description{
This data set from Aitchison (1986), p. 395, describes household expenditures (in former Hong Kong dollars) on five commundity groups.
}
\details{
\itemize{
\item{\code{housing }}{housing (including fuel and light)}
\item{\code{foodstuffs }}{foodstuffs}
\item{\code{alcohol }}{alcohol and tobacco}
\item{\code{other }}{other goods (including clothing, footwear and durable goods)}
\item{\code{services }}{services (including transport and vehicles)}
}

This data set contains household expenditures on five commodity groups of 20 single men. The variables represent housing (including fuel and light), foodstuff, alcohol and tobacco, other goods (including clothing, footwear and durable goods) and services (including transport and vehicles). Thus they represent the ratios of the men's income spent on the mentioned expenditures.
}
\examples{

data(expenditures)
## imputing a missing value in the data set using k-nearest neighbor imputation:
expenditures[1,3]
expenditures[1,3] <- NA
impKNNa(expenditures)$xImp[1,3]
}
\references{
Aitchison, J. (1986) \emph{The Statistical Analysis of Compositional Data} Monographs on Statistics and Applied Probability. Chapman and Hall Ltd., London (UK). 416p.
}
\author{
Matthias Templ \email{matthias.templ@tuwien.ac.at}, Karel Hron
}
\keyword{data}
