% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_apps.R
\name{robmed_GUI}
\alias{robmed_GUI}
\title{Graphical user interface for (robust) mediation analysis}
\usage{
robmed_GUI(data = NULL)
}
\arguments{
\item{data}{optional; a data frame to be selected by default in the
graphical user interface.  Note that if the supplied object is not a
data frame or does not exist in the global environment, the graphical
user interface is opened as if the argument were not supplied.}
}
\value{
No return value, the function is called for its side effect of starting a
\pkg{shiny} app.
}
\description{
Open a \pkg{shiny} app that provides a graphical user interface for (robust)
mediation analysis via package \pkg{robmed}.
}
\details{
The graphical user interface allows to select or import a data set, to
perform the robust bootstrap test ROBMED (Alfons et al., 2022a) or the OLS
bootstrap test (e.g., Preacher & Hayes, 2004, 2008), and to easily export
results for reporting (including a replication file in the form of an \R
script).
}
\note{
The graphical user interface is still experimental.  It may change in future
versions based on user feedback.
}
\examples{
\dontrun{

# start graphical user interface
robmed_GUI()
}


}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2022a) A Robust Bootstrap Test
for Mediation Analysis.  \emph{Organizational Research Methods},
\bold{25}(3), 591--617.  doi:10.1177/1094428121999096.

Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2022b) Robust Mediation
Analysis: The \R Package \pkg{robmed}.  \emph{Journal of Statistical
Software}, \bold{103}(13), 1--45.  doi:10.18637/jss.v103.i13.

Preacher, K.J. and Hayes, A.F. (2004) SPSS and SAS Procedures for Estimating
Indirect Effects in Simple Mediation Models.  \emph{Behavior Research
Methods, Instruments, & Computers}, \bold{36}(4), 717--731.
doi:10.3758/bf03206553.

Preacher, K.J. and Hayes, A.F. (2008) Asymptotic and Resampling Strategies
for Assessing and Comparing Indirect Effects in Multiple Mediator Models.
\emph{Behavior Research Methods}, \bold{40}(3), 879--891.
doi:10.3758/brm.40.3.879.
}
\seealso{
\code{\link{test_mediation}}
}
\author{
Andreas Alfons and Aurore Archimbaud, based on an initial prototype by
Vincent Drenth.
}
