% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{constants}
\alias{constants}
\title{Calculate constants across estimation}
\usage{
constants(
  call,
  formula,
  data,
  reference = c("normal"),
  sign_level,
  estimator,
  split,
  shuffle,
  shuffle_seed,
  iter,
  criterion,
  user_model
)
}
\arguments{
\item{call}{A record of the original function call.}

\item{formula}{The regression formula specified in the function call.}

\item{data}{The dataframe used in the function call.}

\item{reference}{A character vector of length 1 that denotes a valid
reference distribution.}

\item{sign_level}{A numeric value between 0 and 1 that determines the cutoff
in the reference distribution against which observations are judged as
outliers or not.}

\item{estimator}{A character vector specifying which initial estimator was
used.}

\item{split}{A numeric value strictly between 0 and 1 that specifies how the
sample is split in case of saturated 2SLS. \code{NULL} otherwise.}

\item{shuffle}{A logical value whether the sample is re-arranged in random
order before splitting the sample in case of saturated 2SLS. \code{NULL}
otherwise.}

\item{shuffle_seed}{A numeric value setting the seed for the shuffling of the
sample. Only used if \code{shuffle == TRUE}. NULL otherwise.}

\item{iter}{An integer value setting the number of iterations of the
outlier-detection algorithm.}

\item{criterion}{A numeric value that determines when the iterated
outlier-detection algorithm stops by comparing it to the sum of squared
differences between the m- and (m-1)-step parameter estimates. NULL if
convergence criterion should not be used.}

\item{user_model}{A model object of \link{class} \link[AER]{ivreg}. Only
required if argument \code{initial_est} is set to \code{"user"}, otherwise
\code{NULL}.}

\item{verbose}{A logical value whether progress during estimation should be
reported.}
}
\value{
Returns a list that stores values that are constant across the
estimation. It is used to fill parts of the \code{"robust2sls"} class object,
which is returned by \link{outlier_detection}.
\describe{
  \item{\code{$call}}{The captured function call.}
  \item{\code{$verbose}}{The verbose argument (TRUE/FALSE).}
  \item{\code{$formula}}{The formula argument.}
  \item{\code{$data}}{The original data set.}
  \item{\code{$reference}}{The chosen reference distribution to classify
  outliers.}
  \item{\code{$sign_level}}{The significance level determining the cutoff.}
  \item{\code{$psi}}{The probability that an observation is not classified as
  an outlier under the null hypothesis of no outliers.}
  \item{\code{$cutoff}}{The cutoff used to classify outliers if
  their standardised residuals are larger than that value.}
  \item{\code{$bias_corr}}{A numeric bias correction factor to account for
  potential false positives (observations classified as outliers even though
  they are not).}
  \item{\code{$initial}}{A list storing settings about the initial estimator:
  \code{$estimator} is the type of the initial estimator (e.g. robustified or
  saturated), \code{$split} how the sample is split (\code{NULL} if argument
  not used), \code{$shuffle} whether the sample is shuffled before splitting
  (\code{NULL} if argument not used), \code{$shuffle_seed} the value of the
  random seed (\code{NULL} if argument not used), \code{$user} the
  user-specified initial model (\code{NULL} if not used).}
  \item{\code{$convergence}}{A list storing information about the convergence
  of the outlier-detection algorithm: \code{$criterion} is the user-specified
  convergence criterion (\code{NULL} if argument not used),
  \code{$difference} is initialised as \code{NULL}. \code{$converged} is
  initialised as \code{NULL}. \code{$iter} is initialised as \code{NULL}.}
  \item{\code{$iterations}}{A list storing information about the iterations
  of the algorithm. \code{$setting} stores the user-specified
  \code{iterations} argument. \code{$actual} is initialised as \code{NULL}
  and will store the actual number of iterations done.}
}
}
\description{
\code{constants} calculates various values that do not change across the
estimation and records them in a list.
}
\keyword{internal}
