% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_codes_to_txt.R
\name{export_codes_to_txt}
\alias{export_codes_to_txt}
\title{Export codes to a plain text file}
\usage{
export_codes_to_txt(
  input,
  output = NULL,
  codeTree = "fullyMergedCodeTrees",
  codingScheme = "codes",
  regex = ".*",
  onlyChildrenOf = NULL,
  leavesOnly = TRUE,
  includePath = TRUE,
  preventOverwriting = rock::opts$get(preventOverwriting),
  encoding = rock::opts$get(encoding),
  silent = rock::opts$get(silent)
)
}
\arguments{
\item{input}{An object of class \code{rock_parsedSource} (as resulting from a call
to \code{parse_source}) or of class \code{rock_parsedSources} (as resulting from a call
to \code{parse_sources}.}

\item{output}{THe filename to write to.}

\item{codeTree}{Codes from which code tree to export the codes. Valid options
are \code{fullyMergedCodeTrees}, \code{extendedDeductiveCodeTrees}, \code{deductiveCodeTrees},
and \code{inductiveCodeTrees}.}

\item{codingScheme}{With the ROCK, it's possible to use multiple coding scheme's
in parallel. The ROCK default is called \code{codes} (using the double square brackets
as code delimiters), but other delimiters can be used as well, and give a different
name. Use \code{codingScheme} to specify which code tree you want to export, if you
have multiple.}

\item{regex}{An optional regular expression: only codes matching this regular
expression will be selected.}

\item{onlyChildrenOf}{A character vector of one or more regular expressions that
specify codes within which to search. For example, if the code tree contains codes
\code{parent1} and \code{parent2}, and each have a number of child codes, and \code{parent} is
passed as \code{onlyChildrenOf}, only the codes within \code{parent} are selected.}

\item{leavesOnly}{Whether to only write the leaves (i.e. codes that don't have
children) or all codes in the code tree.}

\item{includePath}{Whether to only return the code itself (e.g. \code{code}) or also
include the path to the root (e.g. \verb{code1>code2>code}).}

\item{preventOverwriting}{Whether to prevent overwriting of output files.}

\item{encoding}{The encoding to use when writing the exported source(s).}

\item{silent}{Whether to suppress messages.}
}
\value{
A character vector.
}
\description{
These function can be used to convert one or more parsed sources to HTML,
or to convert all sources to tabbed sections in Markdown.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Parse a selection of example sources in that directory
parsedExamples <-
  rock::parse_sources(
    examplePath,
    regex = "(test|example)(.txt|.rock)"
  );

### Show results of exporting the codes
rock::export_codes_to_txt(parsedExamples);

### Only show select a narrow set of codes
rock::export_codes_to_txt(
  parsedExamples,
  leavesOnly=TRUE,
  includePath=FALSE,
  onlyChildrenOf = "inductFather",
  regex="3|5"
);

}
