% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync_streams.R
\name{sync_streams}
\alias{sync_streams}
\title{Synchronize multiple streams}
\usage{
sync_streams(
  x,
  primaryStream,
  columns = NULL,
  anchorsCol = rock::opts$get("anchorsCol"),
  sourceId = rock::opts$get("sourceId"),
  streamId = rock::opts$get("streamId"),
  prependStreamIdToColName = FALSE,
  appendStreamIdToColName = FALSE,
  sep = " ",
  fill = TRUE,
  compressFun = NULL,
  compressFunPart = NULL,
  expandFun = NULL,
  colNameGlue = rock::opts$get("colNameGlue"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{x}{The object with the parsed sources.}

\item{primaryStream}{The identifier of the primary stream.}

\item{columns}{The names of the column(s) to synchronize.}

\item{anchorsCol}{The column containing the anchors.}

\item{sourceId}{The column containing the source identifiers.}

\item{streamId}{The column containing the stream identifiers.}

\item{prependStreamIdToColName, appendStreamIdToColName}{Whether to append
or prepend the stream identifier before merging the dataframes together.}

\item{sep}{When not specifying \code{compressFun} and \code{compressFunPart}, the
\code{paste} function is used to combine elements, and in that case, \code{sep} is
passed to \code{paste} as separator.}

\item{fill}{When expanding streams, whether to duplicate elements to fill
the resulting vector. Ignored if \code{fillFun} is specified.}

\item{compressFun}{If specified, when compressing streams, instead of pasting
elements together using separator \code{sep}, the vectors are passed to function
\code{compressFun}, which must accept a vector (to compress) and a single integer
(with the desired resulting length of the vector).}

\item{compressFunPart}{A function to apply to the segments that are
automatically created; this can be passed instead of \code{compressFun}.}

\item{expandFun}{If specified, when expanding streams, instead of potentially
filling the new larger vector with elements (if \code{fill} is \code{TRUE}), the
vectors are passed to function \code{expandFun}, which must accept a vector (to
compress) and a single integer (with the desired resulting length of
the vector).}

\item{colNameGlue}{When appending or prepending stream identifiers, the
character(s) to use as "glue" or separator.}

\item{silent}{Whether to be silent (\code{TRUE}) or chatty (\code{FALSE}).}
}
\value{
The object with parsd sources, \code{x}, with the synchronization results
added in the \verb{$syncResults} subobject.
}
\description{
This function maps the codes from multiple streams onto a primary stream.
}
\examples{
### Get a directory with example sources
examplePath <-
  file.path(
    system.file(package="rock"),
    'extdata',
    'streams'
  );

### Parse the sources
parsedSources <- rock::parse_sources(
  examplePath
);

### Add a dataframe, syncing all streams to primary stream !
parsedSources <- rock::sync_streams(
  parsedSources,
  primaryStream = "streamA",
  columns = c("Code1", "Code2", "Code3"),
  prependStreamIdToColName = TRUE
);

### Look at two examples
parsedSources$syncResults$mergedSourceDf[
  ,
  c("streamB_Code3", "streamC_Code1")
];
}
