% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_source_filter.R
\name{get_source_filter}
\alias{get_source_filter}
\title{Create a filter to select utterances in a source}
\usage{
get_source_filter(
  source,
  filter,
  ignore.case = TRUE,
  invert = FALSE,
  perl = TRUE,
  ...
)
}
\arguments{
\item{source}{The source to produce the filter for.}

\item{filter}{THe filtering criterion: a character vector with regular expressions,
a numeric vector with numeric indices, or a logical vector that is either
as long as the source or has length 1.}

\item{ignore.case}{Whether to apply the regular expression case sensitively
or not (see \code{\link[base:grep]{base::grepl()}}).}

\item{invert}{Whether to invert the result or not (i.e. whether the filter
specifies what you want to select (\code{invert=FALSE}) or what you don't want
to select (\code{invert=TRUE})).}

\item{perl}{Whether the regular expression (if \code{filter} is a character
vector) is a perl regular expression or not (see \code{\link[base:grep]{base::grepl()}}).}

\item{...}{Any additional arguments are passed on to \code{\link[base:grep]{base::grepl()}}.}
}
\value{
A logical vector of the same length as the source.
}
\description{
This function takes a character vector with regular expressions,
a numeric vector with numeric indices, or a logical vector that is either
as long as the source or has length 1; and then always returns a logical
vector of the same length as the source.
}
