% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{formatNumericSummaries}
\alias{formatNumericSummaries}
\title{Numeric output data.frame from summarize is reformatted as one
column per variable with summary statistics in the rows}
\usage{
formatNumericSummaries(x, digits = 2, ...)
}
\arguments{
\item{x}{numeric summaries from summarize function}

\item{digits}{Decimal values to display, defaults as 2.}

\item{...}{Other arguments, currently not used}
}
\value{
A text matrix to represent the numeric input
}
\description{
The summarizeNumeric function returns a data frame with the
variable names on the rows and summary statistics (mean, median,
std. deviation) in the columns.  For consistency with appearance
of R's summary function
}
\examples{
set.seed(21234)
X <- matrix(rnorm(10000), ncol = 10)
Xsum <- summarize(X)
Xsum$numerics
formatNumericSummaries(Xsum$numerics)
formatNumericSummaries(Xsum$numerics, digits = 5)
}
\author{
Paul Johnson
}
