% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{addBalanceTable}
\alias{addBalanceTable}
\title{Add the balancing table to the final output
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.}
\usage{
addBalanceTable(reduced_data, vars, tm, id, combined_output, treat, matches)
}
\arguments{
\item{reduced_data}{Dataframe of reduced treatment and comparison data}

\item{vars}{A vector of dataframe column names}

\item{tm}{The time period indicator}

\item{id}{ID variable in dataset}

\item{combined_output}{A list of output for the rollmatch package. 
See makeOutput}

\item{treat}{The Treatment variable}

\item{matches}{Dataframe containing the matches from comparison_pool}
}
\value{
\code{output} returns a list containing the following additional
component to the list out:
\item{balance}{The balancing table.}
}
\description{
Add the balancing table to the final output
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.
}
\examples{
\dontrun{ 
fm <- as.formula(treat ~ qtr_pmt + yr_pmt + age + is_male + is_white +
                 is_disabled + is_esrd + months_dual + chron_num+lq_ed+
                 yr_ed2 + lq_ip + yr_ip2)
vars <- all.vars(formula); treat <- vars[1]
tm <- "quarter"; id <- "indiv_id"
}

}
\keyword{internal}
