% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hclust.R
\name{downsample_heatmap}
\alias{downsample_heatmap}
\title{Downsample Heatmap}
\usage{
downsample_heatmap(
  tidy_data,
  value_var,
  design,
  max_display_features = 1000,
  verbose = TRUE
)
}
\arguments{
\item{tidy_data}{The data frame from a \code{tidy_omic} object containing
ordered feature and sample primary keys defined by ordered_featureId
and ordered_sampleId.}

\item{value_var}{which variable in "measurements" to use for quantification.}

\item{design}{a list summarizing the design of the tidy dataset}

\item{max_display_features}{aggregate and downsample distinct feature to
this number to speed to up heatmap rendering.}

\item{verbose}{extra reporting messages}
}
\value{
tidy_data with rows collapsed if the number of distinct features is
  greater than \code{max_display_features}
}
\description{
Combine rows to speed up rendering of large heatmaps
}
