% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_cases.R
\name{complete_cases}
\alias{complete_cases}
\alias{length_cc}
\alias{n_unique_cc}
\alias{min_cc}
\alias{max_cc}
\alias{range_cc}
\alias{all_cc}
\alias{any_cc}
\alias{sum_cc}
\alias{prod_cc}
\alias{mean_cc}
\alias{median_cc}
\alias{var_cc}
\alias{cov_cc}
\alias{cor_cc}
\alias{sd_cc}
\alias{weighted.mean_cc}
\alias{quantile_cc}
\alias{IQR_cc}
\alias{mad_cc}
\alias{rowSums_cc}
\alias{colSums_cc}
\alias{rowMeans_cc}
\alias{colMeans_cc}
\title{Statistics/Summaries with (Only) Missing Data Removed}
\usage{
length_cc(x, ...)

n_unique_cc(x, ...)

min_cc(x, ...)

max_cc(x, ...)

range_cc(x, ...)

all_cc(x, ...)

any_cc(x, ...)

sum_cc(x, ...)

prod_cc(x, ...)

mean_cc(x, ...)

median_cc(x, ...)

var_cc(x, y = NULL, ...)

cov_cc(x, y = NULL, ...)

cor_cc(x, y = NULL, ...)

sd_cc(x, ...)

weighted.mean_cc(x, w, ...)

quantile_cc(x, ...)

IQR_cc(x, ...)

mad_cc(x, ...)

rowSums_cc(x, ...)

colSums_cc(x, ...)

rowMeans_cc(x, ..., rescale = FALSE)

colMeans_cc(x, ..., rescale = FALSE)
}
\arguments{
\item{x}{An \R object.  Currently there are methods for
    numeric/logical vectors and \link[base:Dates]{date},
    \link[base]{date-time} and \link[base]{time interval} objects.  Complex vectors
    are allowed for \code{trim = 0}, only.}

\item{...}{arguments to pass to wrapped functions}

\item{y}{\code{NULL} (default) or a vector, matrix or data frame with
    compatible dimensions to \code{x}.   The default is equivalent to
    \code{y = x} (but more efficient).}

\item{w}{a numerical vector of weights the same length as \code{x} giving
    the weights to use for elements of \code{x}.}

\item{rescale}{whether to rescale the matrix/df/vector before calculating
summaries}
}
\description{
Univariate and bivariate summaries and statistics with the least missing
data removed (such as complete-cases correlations). These are typically
default arguments to standard statistics functions.
}
\examples{
n_o <- 20
n_m <- round(n_o / 3)
x   <- rnorm(n_o)
y   <- rnorm(n_o)

x[sample(n_o, n_m)] <- NA
y[sample(n_o, n_m)] <- NA

mean_cc(x)   # mean of complete cases
mean_cc(y)
var_cc(x)    # variance of complete cases
var_cc(y)
cor_cc(x, y) # correlation between available cases

}
