% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_checks.R
\name{file_checks}
\alias{file_checks}
\alias{is_txt_file}
\alias{is_csv_file}
\alias{is_excel_file}
\alias{is_r_file}
\alias{is_rdata_file}
\alias{is_rda_file}
\alias{is_rds_file}
\alias{is_spss_file}
\alias{check_ext_against}
\title{File Extension Checks}
\usage{
is_txt_file(x)

is_csv_file(x)

is_excel_file(x)

is_r_file(x)

is_rdata_file(x)

is_rda_file(x)

is_rds_file(x)

is_spss_file(x)

check_ext_against(x, ext = "txt")
}
\arguments{
\item{x}{file(s) to be tested}

\item{ext}{extension to test against}
}
\value{
a logical value
}
\description{
Check whether file extension is as specified
}
\note{
These only check the file extension and not the contents of the file. Checking
the contents of a file might come later but would be quite a bit more involved.
You can use \code{readr} or \code{readxl} (for example) to check the file contents.
}
\examples{
# create your own file extension checks
is_word_file <- function(x){
  check_ext_against(x, ext = c("doc", "docx"))
}
is_word_file(c("blah.doc", "blah.docx", "blah.txt"))
}
