
# This file is automatically generated, you probably don't want to edit this

factorAnalysisjmvOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "factorAnalysisjmvOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            items = NULL,
            nFactorMethod = "eigen",
            nFactors = 1,
            minEigen = 1,
            extraction = "minres",
            rotation = "oblimin",
            colorLoadings = TRUE,
            screePlot = FALSE,
            eigen = FALSE,
            factorCor = FALSE,
            factorSummary = FALSE,
            modelFit = FALSE, ...) {

            super$initialize(
                package='rosetta',
                name='factorAnalysisjmv',
                requiresData=TRUE,
                ...)

            private$..items <- jmvcore::OptionVariables$new(
                "items",
                items,
                takeFromDataIfMissing=TRUE,
                suggested=list(
                    "ordinal",
                    "continuous"),
                permitted=list(
                    "numeric"),
                rejectInf=FALSE)
            private$..nFactorMethod <- jmvcore::OptionList$new(
                "nFactorMethod",
                nFactorMethod,
                options=list(
                    "eigen",
                    "fixed"),
                default="eigen")
            private$..nFactors <- jmvcore::OptionInteger$new(
                "nFactors",
                nFactors,
                min=1,
                default=1)
            private$..minEigen <- jmvcore::OptionNumber$new(
                "minEigen",
                minEigen,
                default=1)
            private$..extraction <- jmvcore::OptionList$new(
                "extraction",
                extraction,
                options=list(
                    "minres",
                    "ml",
                    "pa",
                    "wls",
                    "gls",
                    "minchi"),
                default="minres")
            private$..rotation <- jmvcore::OptionList$new(
                "rotation",
                rotation,
                options=list(
                    "none",
                    "varimax",
                    "quartimax",
                    "promax",
                    "Promax",
                    "oblimin",
                    "simplimax"),
                default="oblimin")
            private$..colorLoadings <- jmvcore::OptionBool$new(
                "colorLoadings",
                colorLoadings,
                default=TRUE)
            private$..screePlot <- jmvcore::OptionBool$new(
                "screePlot",
                screePlot,
                default=FALSE)
            private$..eigen <- jmvcore::OptionBool$new(
                "eigen",
                eigen,
                default=FALSE)
            private$..factorCor <- jmvcore::OptionBool$new(
                "factorCor",
                factorCor,
                default=FALSE)
            private$..factorSummary <- jmvcore::OptionBool$new(
                "factorSummary",
                factorSummary,
                default=FALSE)
            private$..modelFit <- jmvcore::OptionBool$new(
                "modelFit",
                modelFit,
                default=FALSE)

            self$.addOption(private$..items)
            self$.addOption(private$..nFactorMethod)
            self$.addOption(private$..nFactors)
            self$.addOption(private$..minEigen)
            self$.addOption(private$..extraction)
            self$.addOption(private$..rotation)
            self$.addOption(private$..colorLoadings)
            self$.addOption(private$..screePlot)
            self$.addOption(private$..eigen)
            self$.addOption(private$..factorCor)
            self$.addOption(private$..factorSummary)
            self$.addOption(private$..modelFit)
        }),
    active = list(
        items = function() private$..items$value,
        nFactorMethod = function() private$..nFactorMethod$value,
        nFactors = function() private$..nFactors$value,
        minEigen = function() private$..minEigen$value,
        extraction = function() private$..extraction$value,
        rotation = function() private$..rotation$value,
        colorLoadings = function() private$..colorLoadings$value,
        screePlot = function() private$..screePlot$value,
        eigen = function() private$..eigen$value,
        factorCor = function() private$..factorCor$value,
        factorSummary = function() private$..factorSummary$value,
        modelFit = function() private$..modelFit$value),
    private = list(
        ..items = NA,
        ..nFactorMethod = NA,
        ..nFactors = NA,
        ..minEigen = NA,
        ..extraction = NA,
        ..rotation = NA,
        ..colorLoadings = NA,
        ..screePlot = NA,
        ..eigen = NA,
        ..factorCor = NA,
        ..factorSummary = NA,
        ..modelFit = NA)
)

factorAnalysisjmvResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        loadings = function() private$.items[["loadings"]],
        factorStats = function() private$.items[["factorStats"]],
        modelFit = function() private$.items[["modelFit"]],
        eigen = function() private$.items[["eigen"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Factor Analysis")
            self$add(jmvcore::Html$new(
                options=options,
                name="loadings",
                title="Factor Loadings",
                refs="psych",
                clearWith=list(
                    "items",
                    "nFactorMethod",
                    "nFactors",
                    "hideLoadings",
                    "rotation")))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    factorSummary = function() private$.items[["factorSummary"]],
                    factorCor = function() private$.items[["factorCor"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="factorStats",
                            title="Factor Statistics")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="factorSummary",
                            title="Summary",
                            visible="(factorSummary)",
                            clearWith=list(
                                "vars",
                                "nFactorMethod",
                                "nFactors",
                                "rotation"),
                            columns=list(
                                list(
                                    `name`="comp", 
                                    `title`="Factor", 
                                    `type`="text"),
                                list(
                                    `name`="loadings", 
                                    `title`="SS Loadings", 
                                    `type`="number"),
                                list(
                                    `name`="varProp", 
                                    `title`="% of Variance", 
                                    `type`="number"),
                                list(
                                    `name`="varCum", 
                                    `title`="Cumulative %", 
                                    `type`="number"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="factorCor",
                            title="Correlation Matrix",
                            visible="(factorCor)",
                            clearWith=list(
                                "vars",
                                "nFactorMethod",
                                "nFactors",
                                "hideLoadings",
                                "rotation"),
                            columns=list(
                                list(
                                    `name`="comp", 
                                    `title`="", 
                                    `type`="text", 
                                    `format`="narrow"),
                                list(
                                    `name`="pc1", 
                                    `title`="1", 
                                    `type`="number"))))}))$new(options=options))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    fit = function() private$.items[["fit"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="modelFit",
                            title="Model Fit")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="fit",
                            title="Model Fit Measures",
                            rows=1,
                            visible=FALSE,
                            clearWith=list(
                                "vars",
                                "nFactorMethod",
                                "nFactors",
                                "rotation"),
                            columns=list(
                                list(
                                    `name`="rmsea", 
                                    `title`="RMSEA", 
                                    `type`="number"),
                                list(
                                    `name`="rmseaLower", 
                                    `title`="Lower", 
                                    `type`="number", 
                                    `superTitle`="RMSEA 90% CI"),
                                list(
                                    `name`="rmseaUpper", 
                                    `title`="Upper", 
                                    `type`="number", 
                                    `superTitle`="RMSEA 90% CI"),
                                list(
                                    `name`="tli", 
                                    `title`="TLI", 
                                    `type`="number"),
                                list(
                                    `name`="bic", 
                                    `title`="BIC", 
                                    `type`="number"),
                                list(
                                    `name`="chi", 
                                    `title`="\u03C7\u00B2", 
                                    `type`="number", 
                                    `superTitle`="Model Test"),
                                list(
                                    `name`="df", 
                                    `title`="df", 
                                    `type`="integer", 
                                    `superTitle`="Model Test"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue", 
                                    `superTitle`="Model Test"))))}))$new(options=options))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    initEigen = function() private$.items[["initEigen"]],
                    screePlot = function() private$.items[["screePlot"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="eigen",
                            title="Eigenvalues")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="initEigen",
                            title="Initial Eigenvalues",
                            visible="(eigen)",
                            clearWith=list(
                                "vars"),
                            columns=list(
                                list(
                                    `name`="comp", 
                                    `title`="Factor", 
                                    `type`="text"),
                                list(
                                    `name`="eigen", 
                                    `title`="Eigenvalue", 
                                    `type`="number"),
                                list(
                                    `name`="varProp", 
                                    `title`="% of Variance", 
                                    `type`="number"),
                                list(
                                    `name`="varCum", 
                                    `title`="Cumulative %", 
                                    `type`="number"))))
                        self$add(jmvcore::Image$new(
                            options=options,
                            name="screePlot",
                            title="Scree Plot",
                            visible="(screePlot)",
                            width=500,
                            height=300,
                            renderFun=".screePlot",
                            clearWith=list(
                                "vars",
                                "screePlot",
                                "nFactorMethod",
                                "minEigen")))}))$new(options=options))}))

factorAnalysisjmvBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "factorAnalysisjmvBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'rosetta',
                name = 'factorAnalysisjmv',
                version = c(1,0,0),
                options = options,
                results = factorAnalysisjmvResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE,
                requiresMissings = FALSE)
        }))

#' Factor Analysis
#'
#' 
#' @param data the data as a data frame
#' @param items a vector of strings naming the variables of interest in
#'   \code{data}
#' @param nFactorMethod .
#' @param nFactors .
#' @param minEigen .
#' @param extraction .
#' @param rotation .
#' @param colorLoadings .
#' @param screePlot .
#' @param eigen .
#' @param factorCor .
#' @param factorSummary .
#' @param modelFit .
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$loadings} \tab \tab \tab \tab \tab a html \cr
#'   \code{results$factorStats$factorSummary} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$factorStats$factorCor} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$modelFit$fit} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$eigen$initEigen} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$eigen$screePlot} \tab \tab \tab \tab \tab an image \cr
#' }
#'
#' @export
factorAnalysisjmv <- function(
    data,
    items,
    nFactorMethod = "eigen",
    nFactors = 1,
    minEigen = 1,
    extraction = "minres",
    rotation = "oblimin",
    colorLoadings = TRUE,
    screePlot = FALSE,
    eigen = FALSE,
    factorCor = FALSE,
    factorSummary = FALSE,
    modelFit = FALSE) {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop('factorAnalysisjmv requires jmvcore to be installed (restart may be required)')

    if ( ! missing(items)) items <- jmvcore::resolveQuo(jmvcore::enquo(items))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(items), items, NULL))

    items <- `if`( ! missing(items), items, colnames(data))

    options <- factorAnalysisjmvOptions$new(
        items = items,
        nFactorMethod = nFactorMethod,
        nFactors = nFactors,
        minEigen = minEigen,
        extraction = extraction,
        rotation = rotation,
        colorLoadings = colorLoadings,
        screePlot = screePlot,
        eigen = eigen,
        factorCor = factorCor,
        factorSummary = factorSummary,
        modelFit = modelFit)

    analysis <- factorAnalysisjmvClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
