% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RosvVulns.R
\name{RosvVulns}
\alias{RosvVulns}
\title{R6 Class for OSV Vulns Endpoint}
\value{
An R6 object to operate with OSV vulns endpoint.
}
\description{
An R6 class to provide a lower-level interface to the vulnerability
endpoint of the OSV API.
}
\examples{
vulns <- RosvVulns$new(c('RSEC-2023-6', 'GHSA-jq35-85cj-fj4p'))
vulns

}
\seealso{
\url{https://google.github.io/osv.dev/get-v1-vulns/}
}
\section{Super class}{
\code{\link[rosv:RosvQuery1]{rosv::RosvQuery1}} -> \code{RosvVulns}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RosvVulns-new}{\code{RosvVulns$new()}}
\item \href{#method-RosvVulns-run}{\code{RosvVulns$run()}}
\item \href{#method-RosvVulns-print}{\code{RosvVulns$print()}}
\item \href{#method-RosvVulns-clone}{\code{RosvVulns$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rosv" data-topic="RosvQuery1" data-id="parse"><a href='../../rosv/html/RosvQuery1.html#method-RosvQuery1-parse'><code>rosv::RosvQuery1$parse()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvVulns-new"></a>}}
\if{latex}{\out{\hypertarget{method-RosvVulns-new}{}}}
\subsection{Method \code{new()}}{
Set the core request details for subsequent use when called in \code{run()} method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvVulns$new(vuln_ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vuln_ids}}{Character vector of vulnerability IDs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvVulns-run"></a>}}
\if{latex}{\out{\hypertarget{method-RosvVulns-run}{}}}
\subsection{Method \code{run()}}{
Perform the request and return response for OSV API call.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvVulns$run()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvVulns-print"></a>}}
\if{latex}{\out{\hypertarget{method-RosvVulns-print}{}}}
\subsection{Method \code{print()}}{
Print basic details of query object to screen.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvVulns$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Reserved for possible future use.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RosvVulns-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RosvVulns-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RosvVulns$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
