% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/match_names.R
\name{ott_id.match_names}
\alias{flags}
\alias{flags.match_names}
\alias{ott_id.match_names}
\title{\code{ott_id} and \code{flags} for taxonomic names matched
    by \code{tnrs_match_names}}
\usage{
\method{ott_id}{match_names}(tax, row_number, taxon_name, ott_id,
  only_current = TRUE, ...)

flags(tax, ...)

\method{flags}{match_names}(tax, row_number, taxon_name, ott_id,
  only_current = TRUE, ...)
}
\arguments{
\item{tax}{an object returned by \code{\link{tnrs_match_names}}}

\item{row_number}{the row number corresponding to the name for
which to list the synonyms}

\item{taxon_name}{the taxon name corresponding to the name for
which to list the synonyms}

\item{ott_id}{the ott id corresponding to the name for which to
list the synonyms}

\item{only_current}{logical (default \code{TRUE}), should the
results include data for all matched names, or only the one
listed in the object returned by
\code{\link{tnrs_match_names}}?}

\item{...}{currently ignored}
}
\value{
A list of the ott ids or flags for the taxonomic names
    matched with \code{\link{tnrs_match_names}}, for either one or
    all the names.
}
\description{
\code{rotl} provides a collection of functions that allows users
to extract relevant information from an object generated by
\code{\link{tnrs_match_names}} function.
}
\details{
These methods optionally accept one of the arguments
\code{row_number}, \code{taxon_name} or \code{ott_id} to retrieve
the corresponding information for one of the matches in the object
returned by the \code{\link{tnrs_match_names}} function.

If these arguments are not provided, these methods can return
information for the matches currently listed in the object
returned by \code{\link{tnrs_match_names}} (the default) or all
the matches (using \code{only_current = FALSE}).
}
\examples{
\dontrun{
  rsp <- tnrs_match_names(c("Diadema", "Tyrannosaurus"))
  rsp$ott_id    # ott id for match currently in use
  ott_id(rsp)   # similar as above but elements are named
  ott_id(rsp, only_current=FALSE) # ott id for all possible taxonomic matches

  ## flags() is useful for instance to determine if a taxon is extinct
  flags(rsp, taxon_name="Tyrannosaurus")
}
}

